/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.vectfield;

import java.util.ArrayList;
import org.scilab.modules.graphic_objects.contouredObject.Line;
import org.scilab.modules.graphic_objects.graphicObject.GraphicClippableObject;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.vectfield.Arrow;

public abstract class VectField
extends GraphicClippableObject {
    protected ArrayList<Arrow> arrows = new ArrayList(0);

    @Override
    public Object getPropertyFromName(int n) {
        switch (n) {
            case 272: {
                return VectFieldProperty.ARROWS;
            }
            case 273: {
                return VectFieldProperty.NUMBERARROWS;
            }
            case 261: {
                return Arrow.ArrowProperty.BASE;
            }
            case 262: {
                return Arrow.ArrowProperty.BASEX;
            }
            case 263: {
                return Arrow.ArrowProperty.BASEY;
            }
            case 264: {
                return Arrow.ArrowProperty.BASEZ;
            }
            case 265: {
                return Arrow.ArrowProperty.DIRECTION;
            }
            case 266: {
                return Arrow.ArrowProperty.DIRECTIONX;
            }
            case 267: {
                return Arrow.ArrowProperty.DIRECTIONY;
            }
            case 268: {
                return Arrow.ArrowProperty.DIRECTIONZ;
            }
            case 269: {
                return Arrow.ArrowProperty.ARROWSIZE;
            }
            case 192: {
                return Line.LinePropertyType.MODE;
            }
            case 193: {
                return Line.LinePropertyType.LINESTYLE;
            }
            case 194: {
                return Line.LinePropertyType.THICKNESS;
            }
        }
        return super.getPropertyFromName(n);
    }

    @Override
    public Object getProperty(Object object) {
        if (object == VectFieldProperty.ARROWS) {
            return this.getArrows();
        }
        if (object == VectFieldProperty.NUMBERARROWS) {
            return this.getNumberArrows();
        }
        if (object == Arrow.ArrowProperty.BASE) {
            return this.getBase();
        }
        if (object == Arrow.ArrowProperty.BASEX) {
            return this.getBaseX();
        }
        if (object == Arrow.ArrowProperty.BASEY) {
            return this.getBaseY();
        }
        if (object == Arrow.ArrowProperty.BASEZ) {
            return this.getBaseZ();
        }
        if (object == Arrow.ArrowProperty.DIRECTION) {
            return this.getDirection();
        }
        if (object == Arrow.ArrowProperty.DIRECTIONX) {
            return this.getDirectionX();
        }
        if (object == Arrow.ArrowProperty.DIRECTIONY) {
            return this.getDirectionY();
        }
        if (object == Arrow.ArrowProperty.DIRECTIONZ) {
            return this.getDirectionZ();
        }
        if (object == Arrow.ArrowProperty.ARROWSIZE) {
            return this.getArrowSize();
        }
        if (object == Line.LinePropertyType.MODE) {
            return this.getLineMode();
        }
        if (object == Line.LinePropertyType.LINESTYLE) {
            return this.getLineStyle();
        }
        if (object == Line.LinePropertyType.THICKNESS) {
            return this.getLineThickness();
        }
        return super.getProperty(object);
    }

    @Override
    public GraphicObject.UpdateStatus setProperty(Object object, Object object2) {
        if (object == VectFieldProperty.ARROWS) {
            this.setArrows((ArrayList)object2);
        } else if (object == VectFieldProperty.NUMBERARROWS) {
            this.setNumberArrows((Integer)object2);
        } else if (object == Arrow.ArrowProperty.BASE) {
            this.setBase((Double[])object2);
        } else if (object == Arrow.ArrowProperty.BASEX) {
            this.setBaseX((Double[])object2);
        } else if (object == Arrow.ArrowProperty.BASEY) {
            this.setBaseY((Double[])object2);
        } else if (object == Arrow.ArrowProperty.BASEZ) {
            this.setBaseZ((Double[])object2);
        } else if (object == Arrow.ArrowProperty.DIRECTION) {
            this.setDirection((Double[])object2);
        } else if (object == Arrow.ArrowProperty.DIRECTIONX) {
            this.setDirectionX((Double[])object2);
        } else if (object == Arrow.ArrowProperty.DIRECTIONY) {
            this.setDirectionY((Double[])object2);
        } else if (object == Arrow.ArrowProperty.DIRECTIONZ) {
            this.setDirectionZ((Double[])object2);
        } else if (object == Arrow.ArrowProperty.ARROWSIZE) {
            this.setArrowSize((Double)object2);
        } else if (object == Line.LinePropertyType.MODE) {
            this.setLineMode((Boolean)object2);
        } else if (object == Line.LinePropertyType.LINESTYLE) {
            this.setLineStyle((Integer)object2);
        } else if (object == Line.LinePropertyType.THICKNESS) {
            this.setLineThickness((Double)object2);
        } else {
            return super.setProperty(object, object2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public ArrayList<Arrow> getArrows() {
        return this.arrows;
    }

    public GraphicObject.UpdateStatus setArrows(ArrayList<Arrow> arrayList) {
        this.arrows = arrayList;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getNumberArrows() {
        return this.arrows.size();
    }

    public GraphicObject.UpdateStatus setNumberArrows(Integer n) {
        if (!this.arrows.isEmpty() && n.intValue() != this.arrows.size()) {
            ArrayList<Arrow> arrayList = new ArrayList<Arrow>(0);
            for (int i = 0; i < n; ++i) {
                Arrow arrow = this.arrows.get(0).clone();
                arrayList.add(arrow);
            }
            this.arrows.clear();
            this.arrows = arrayList;
        } else if (this.arrows.isEmpty()) {
            for (int i = 0; i < n; ++i) {
                this.arrows.add(new Arrow());
            }
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getBase() {
        Double[] doubleArray = new Double[3 * this.arrows.size()];
        for (int i = 0; i < this.arrows.size(); ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getBase();
            doubleArray[3 * i] = doubleArray2[0];
            doubleArray[3 * i + 1] = doubleArray2[1];
            doubleArray[3 * i + 2] = doubleArray2[2];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setBase(Double[] doubleArray) {
        Double[] doubleArray2 = new Double[3];
        int n = Math.min(doubleArray.length / 3, this.arrows.size());
        for (int i = 0; i < n; ++i) {
            doubleArray2[0] = doubleArray[3 * i];
            doubleArray2[1] = doubleArray[3 * i + 1];
            doubleArray2[2] = doubleArray[3 * i + 2];
            this.arrows.get(i).setBase(doubleArray2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getBaseX() {
        Double[] doubleArray = new Double[this.arrows.size()];
        for (int i = 0; i < this.arrows.size(); ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getBase();
            doubleArray[i] = doubleArray2[0];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setBaseX(Double[] doubleArray) {
        int n = Math.min(doubleArray.length, this.arrows.size());
        for (int i = 0; i < n; ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getBase();
            doubleArray2[0] = doubleArray[i];
            this.arrows.get(i).setBase(doubleArray2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getBaseY() {
        Double[] doubleArray = new Double[this.arrows.size()];
        for (int i = 0; i < this.arrows.size(); ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getBase();
            doubleArray[i] = doubleArray2[1];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setBaseY(Double[] doubleArray) {
        int n = Math.min(doubleArray.length, this.arrows.size());
        for (int i = 0; i < n; ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getBase();
            doubleArray2[1] = doubleArray[i];
            this.arrows.get(i).setBase(doubleArray2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getBaseZ() {
        Double[] doubleArray = new Double[this.arrows.size()];
        for (int i = 0; i < this.arrows.size(); ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getBase();
            doubleArray[i] = doubleArray2[2];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setBaseZ(Double[] doubleArray) {
        int n = Math.min(doubleArray.length, this.arrows.size());
        for (int i = 0; i < n; ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getBase();
            doubleArray2[2] = doubleArray[i];
            this.arrows.get(i).setBase(doubleArray2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getDirection() {
        Double[] doubleArray = new Double[3 * this.arrows.size()];
        for (int i = 0; i < this.arrows.size(); ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getDirection();
            doubleArray[3 * i] = doubleArray2[0];
            doubleArray[3 * i + 1] = doubleArray2[1];
            doubleArray[3 * i + 2] = doubleArray2[2];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setDirection(Double[] doubleArray) {
        Double[] doubleArray2 = new Double[3];
        int n = Math.min(doubleArray.length / 3, this.arrows.size());
        for (int i = 0; i < n; ++i) {
            doubleArray2[0] = doubleArray[3 * i];
            doubleArray2[1] = doubleArray[3 * i + 1];
            doubleArray2[2] = doubleArray[3 * i + 2];
            this.arrows.get(i).setDirection(doubleArray2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getDirectionX() {
        Double[] doubleArray = new Double[this.arrows.size()];
        for (int i = 0; i < this.arrows.size(); ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getDirection();
            doubleArray[i] = doubleArray2[0];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setDirectionX(Double[] doubleArray) {
        int n = Math.min(doubleArray.length, this.arrows.size());
        for (int i = 0; i < n; ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getDirection();
            doubleArray2[0] = doubleArray[i];
            this.arrows.get(i).setDirection(doubleArray2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getDirectionY() {
        Double[] doubleArray = new Double[this.arrows.size()];
        for (int i = 0; i < this.arrows.size(); ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getDirection();
            doubleArray[i] = doubleArray2[1];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setDirectionY(Double[] doubleArray) {
        int n = Math.min(doubleArray.length, this.arrows.size());
        for (int i = 0; i < n; ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getDirection();
            doubleArray2[1] = doubleArray[i];
            this.arrows.get(i).setDirection(doubleArray2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double[] getDirectionZ() {
        Double[] doubleArray = new Double[this.arrows.size()];
        for (int i = 0; i < this.arrows.size(); ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getDirection();
            doubleArray[i] = doubleArray2[2];
        }
        return doubleArray;
    }

    public GraphicObject.UpdateStatus setDirectionZ(Double[] doubleArray) {
        int n = Math.min(doubleArray.length, this.arrows.size());
        for (int i = 0; i < n; ++i) {
            Double[] doubleArray2 = this.arrows.get(i).getDirection();
            doubleArray2[2] = doubleArray[i];
            this.arrows.get(i).setDirection(doubleArray2);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getArrowSize() {
        Double d = this.arrows.get(0).getArrowSize();
        return d;
    }

    public GraphicObject.UpdateStatus setArrowSize(Double d) {
        for (int i = 0; i < this.arrows.size(); ++i) {
            this.arrows.get(i).setArrowSize(d);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Boolean getLineMode() {
        Boolean bl = this.arrows.get(0).getLineMode();
        return bl;
    }

    public GraphicObject.UpdateStatus setLineMode(Boolean bl) {
        for (int i = 0; i < this.arrows.size(); ++i) {
            this.arrows.get(i).setLineMode(bl);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getLineStyle() {
        Integer n = this.arrows.get(0).getLineStyle();
        return n;
    }

    public GraphicObject.UpdateStatus setLineStyle(Integer n) {
        for (int i = 0; i < this.arrows.size(); ++i) {
            this.arrows.get(i).setLineStyle(n);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Line.LineType getLineStyleAsEnum() {
        Line.LineType lineType = this.arrows.get(0).getLineStyleAsEnum();
        return lineType;
    }

    public Double getLineThickness() {
        Double d = this.arrows.get(0).getLineThickness();
        return d;
    }

    public GraphicObject.UpdateStatus setLineThickness(Double d) {
        for (int i = 0; i < this.arrows.size(); ++i) {
            this.arrows.get(i).setLineThickness(d);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getLineColor() {
        Integer n = this.arrows.get(0).getLineColor();
        return n;
    }

    public GraphicObject.UpdateStatus setLineColor(Integer n) {
        for (int i = 0; i < this.arrows.size(); ++i) {
            this.arrows.get(i).setLineColor(n);
        }
        return GraphicObject.UpdateStatus.Success;
    }

    private static enum VectFieldProperty {
        ARROWS,
        NUMBERARROWS;

    }
}

