/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.label;

import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.modules.graphic_objects.axes.AxisProperty;
import org.scilab.modules.renderer.JoGLView.label.LabelPositioner;

public class TitlePositioner
extends LabelPositioner {
    public static final double TITLEOFFSET = 8.0;
    private static final double ZNEAR = -1.0;
    private double distRatio;
    private int xlabelHeight;

    public TitlePositioner() {
        this.useWindowCoordinates = true;
    }

    public void setDistanceRatio(double d) {
        this.distRatio = d;
    }

    public void setXLabelHeight(int n) {
        this.xlabelHeight = n;
    }

    @Override
    protected Vector3d computeDisplacedPosition() {
        Transformation transformation = this.drawingTools.getTransformationManager().getCanvasProjection();
        Double[] doubleArray = new Double[]{0.0, 0.0, 0.0, 0.0};
        Double[] doubleArray2 = new Double[]{0.0, 0.0, 0.0, 0.0};
        boolean bl = false;
        if (this.parentAxes != null) {
            doubleArray = this.parentAxes.getAxesBounds();
            doubleArray2 = this.parentAxes.getMargins();
            AxisProperty.AxisLocation axisLocation = this.parentAxes.getXAxis().getAxisLocation();
            if (axisLocation == AxisProperty.AxisLocation.TOP) {
                bl = true;
            }
        }
        double d = doubleArray[0] + doubleArray[2] * doubleArray2[0] + 0.5 * doubleArray[2] * (1.0 - doubleArray2[0] - doubleArray2[1]);
        double d2 = 1.0 - doubleArray[1] - doubleArray[3] * doubleArray2[2];
        Vector3d vector3d = new Vector3d(Math.floor(d * (double)this.drawingTools.getCanvas().getWidth()), Math.floor(d2 * (double)this.drawingTools.getCanvas().getHeight()), -1.0);
        Vector3d vector3d2 = new Vector3d(vector3d);
        vector3d2 = transformation.unproject(vector3d2);
        int n = 0;
        if (bl) {
            n = (int)((1.0 - doubleArray2[2] - doubleArray2[3]) * this.distRatio / 2.0 * doubleArray[3] * (double)this.drawingTools.getCanvas().getHeight()) + this.xlabelHeight;
        }
        vector3d = vector3d.setY(vector3d.getY() + 8.0 + (double)n);
        Vector3d vector3d3 = transformation.unproject(vector3d);
        Vector3d vector3d4 = new Vector3d(vector3d3);
        this.labelPosition = new Vector3d(vector3d2);
        this.labelDisplacement = vector3d3.minus(vector3d2);
        return vector3d4;
    }

    @Override
    protected AnchorPosition getAutoAnchorPosition() {
        return AnchorPosition.DOWN;
    }
}

