/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.legend;

import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.legend.Legend;
import org.scilab.modules.graphic_objects.textObject.TextObject;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.TextObjectSpriteDrawer;

public class LegendSpriteDrawer
extends TextObjectSpriteDrawer
implements TextureDrawer {
    LegendSpriteDrawer(ColorMap colorMap, Legend legend) {
        super(colorMap, (TextObject)legend);
        Appearance appearance = this.computeAppearance(colorMap, legend);
        this.setAppearance(appearance);
        this.setThickness((int)Math.ceil(appearance.getLineWidth()));
    }

    private Appearance computeAppearance(ColorMap colorMap, Legend legend) {
        Appearance appearance = new Appearance();
        if (legend.getFillMode().booleanValue()) {
            Color color = ColorFactory.createColor(colorMap, legend.getBackground());
            appearance.setFillColor(color);
        } else {
            appearance.setFillColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        }
        appearance.setLineWidth(0.0f);
        return appearance;
    }

    private String[][] computeTextData(Legend legend) {
        int n;
        String[] stringArray = legend.getTextStrings();
        String[][] stringArray2 = new String[legend.getLinks().length][1];
        int n2 = Math.min(legend.getLinks().length, stringArray.length);
        for (n = 0; n < n2; ++n) {
            stringArray2[n][0] = stringArray[n];
        }
        if (n2 < legend.getLinks().length) {
            for (n = n2; n < legend.getLinks().length; ++n) {
                stringArray2[n][0] = new String(" ");
            }
        }
        return stringArray2;
    }
}

