/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.JoGLView.text;

import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.appearance.Color;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.textObject.Text;
import org.scilab.modules.graphic_objects.textObject.TextObject;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;
import org.scilab.modules.renderer.JoGLView.util.TextObjectSpriteDrawer;

class TextSpriteDrawer
extends TextObjectSpriteDrawer
implements TextureDrawer {
    private double scaleFactor = 1.0;

    TextSpriteDrawer(ColorMap colorMap, Text text) {
        super(colorMap, (TextObject)text);
        this.setAlignmentFactor(this.computeAlignmentFactor(text));
        Appearance appearance = this.computeAppearance(colorMap, text);
        this.setAppearance(appearance);
        this.setThickness((int)Math.ceil(appearance.getLineWidth()));
    }

    TextSpriteDrawer(ColorMap colorMap, Text text, double d) {
        super(colorMap, (TextObject)text, d);
        this.setAlignmentFactor(this.computeAlignmentFactor(text));
        Appearance appearance = this.computeAppearance(colorMap, text);
        this.setAppearance(appearance);
        this.setThickness((int)Math.ceil(appearance.getLineWidth()));
        this.scaleFactor = d;
    }

    private Appearance computeAppearance(ColorMap colorMap, Text text) {
        Color color;
        Appearance appearance = new Appearance();
        if (text.getBox().booleanValue() && text.getFillMode().booleanValue()) {
            color = ColorFactory.createColor(colorMap, text.getBackground());
            appearance.setFillColor(color);
        } else {
            appearance.setFillColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        }
        if (text.getBox().booleanValue() && text.getLineMode().booleanValue()) {
            color = ColorFactory.createColor(colorMap, text.getLineColor());
            appearance.setLineColor(color);
            appearance.setLineWidth(1.0f);
        } else {
            appearance.setLineWidth(0.0f);
        }
        return appearance;
    }

    @Override
    public int getHMargin() {
        return (int)(this.scaleFactor * (double)super.getHMargin());
    }

    @Override
    public int getVMargin() {
        return (int)(this.scaleFactor * (double)super.getVMargin());
    }

    @Override
    public int getSpaceWidth() {
        return (int)(this.scaleFactor * (double)super.getSpaceWidth());
    }
}

