/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.renderer.utils;

import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.graphic_objects.SurfaceData;
import org.scilab.modules.graphic_objects.axes.Axes;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.renderer.JoGLView.axes.AxesDrawer;
import org.scilab.modules.renderer.utils.ObjectSearcher;

public class CommonHandler {
    public static Boolean objectExists(Integer n) {
        if (n != null && GraphicController.getController().getObjectFromId(n) != null) {
            return true;
        }
        return false;
    }

    public static Boolean isLineEnabled(Integer n) {
        return (Boolean)GraphicController.getController().getProperty(n, 192);
    }

    public static Boolean isMarkEnabled(Integer n) {
        return (Boolean)GraphicController.getController().getProperty(n, 198);
    }

    public static int getStyle(Integer n) {
        return (Integer)GraphicController.getController().getProperty(n, 241);
    }

    public static int getBarWidth(Integer n) {
        return (Integer)GraphicController.getController().getProperty(n, 248);
    }

    public static Integer getMarkStyle(Integer n) {
        return (Integer)GraphicController.getController().getProperty(n, 199);
    }

    public static Integer getMarkSize(Integer n) {
        return (Integer)GraphicController.getController().getProperty(n, 201);
    }

    public static Integer getMarkSizeUnit(Integer n) {
        return (Integer)GraphicController.getController().getProperty(n, 200);
    }

    public static void setSelected(Integer n, boolean bl) {
        if (n == null) {
            return;
        }
        GraphicController.getController().setProperty(n, 206, (Object)bl);
    }

    public static Integer duplicate(Integer n) {
        Integer n2 = null;
        Integer n3 = null;
        n2 = GraphicController.getController().cloneObject(n);
        GraphicController.getController().setGraphicObjectRelationship(Integer.valueOf(0), n2);
        Integer n4 = (Integer)GraphicController.getController().getProperty(n, 29);
        if (n4 == 15) {
            n3 = PolylineData.createPolylineData((int)n, (int)n2);
        } else if (n4 == 14 || n4 == 6 || n4 == 10) {
            n3 = SurfaceData.createObject3dData((int)n, (int)n2, (int)n4);
        }
        if (n3 == null) {
            CommonHandler.delete(n2);
            return null;
        }
        return n2;
    }

    public static void insert(Integer n, Integer n2) {
        Integer n3 = (Integer)GraphicController.getController().getProperty(n2, 29);
        if (n3 == 15) {
            Integer n4 = GraphicController.getController().askObject(GraphicObject.getTypeFromName((int)5));
            GraphicController.getController().setGraphicObjectRelationship(n, n4);
            GraphicController.getController().setGraphicObjectRelationship(n4, n2);
        } else if (n3 == 14 || n3 == 6 || n3 == 10) {
            GraphicController.getController().setGraphicObjectRelationship(n, n2);
        }
    }

    public static void cut(Integer n) {
        GraphicController.getController().setGraphicObjectRelationship(Integer.valueOf(0), n);
    }

    public static void delete(Integer n) {
        GraphicController.getController().removeRelationShipAndDelete(n);
    }

    public static Boolean isVisible(Integer n) {
        return (Boolean)GraphicController.getController().getProperty(n, 27);
    }

    public static void setVisible(Integer n, boolean bl) {
        GraphicController.getController().setProperty(n, 27, (Object)bl);
    }

    public static void unhideAll(Integer n) {
        Integer[] integerArray = new Integer[]{15, 14, 6, 10};
        Integer[] integerArray2 = new ObjectSearcher().searchMultiple(n, integerArray);
        if (integerArray2 != null) {
            for (int i = 0; i < integerArray2.length; ++i) {
                CommonHandler.setVisible(integerArray2[i], true);
            }
        }
    }

    public static Integer getParent(Integer n) {
        return (Integer)GraphicController.getController().getProperty(n, 24);
    }

    public static Integer getParentFigure(Integer n) {
        GraphicObject graphicObject = GraphicController.getController().getObjectFromId(n);
        return graphicObject.getParentFrameOrFigure();
    }

    public static boolean cmpColorMap(Integer n, Integer n2) {
        Double[] doubleArray;
        Double[] doubleArray2 = CommonHandler.getColorMap(n);
        if (doubleArray2.length != (doubleArray = CommonHandler.getColorMap(n2)).length) {
            return false;
        }
        for (int i = 0; i < doubleArray2.length; ++i) {
            if (doubleArray2[i] - doubleArray[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    public static void cloneColorMap(Integer n, Integer n2) {
        Double[] doubleArray = CommonHandler.getColorMap(n);
        GraphicController.getController().setProperty(n2, 90, (Object)doubleArray);
    }

    public static void cloneBackgroundColor(Integer n, Integer n2) {
        Integer n3 = CommonHandler.getBackground(n);
        GraphicController.getController().setProperty(n2, 96, (Object)n3);
    }

    public static Double[] getColorMap(Integer n) {
        return (Double[])GraphicController.getController().getProperty(n, 90);
    }

    public static Integer getBackground(Integer n) {
        return (Integer)GraphicController.getController().getProperty(n, 96);
    }

    public static double logScale(Double d, boolean bl) {
        if (bl) {
            return Math.log10(d);
        }
        return d;
    }

    public static double InverseLogScale(Double d, boolean bl) {
        if (bl) {
            return Math.pow(10.0, d);
        }
        return d;
    }

    public static double[] toLogScale(double[] dArray, boolean bl) {
        if (bl) {
            double[] dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = Math.log10(dArray[i]);
            }
            return dArray2;
        }
        return dArray;
    }

    public static double[] toInverseLogScale(double[] dArray, boolean bl) {
        if (bl) {
            double[] dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = Math.pow(10.0, dArray[i]);
            }
            return dArray2;
        }
        return dArray;
    }

    public static void toLogScale(double[] dArray, boolean[] blArray) {
        if (blArray[0] || blArray[1] || blArray[2]) {
            for (int i = 0; i < dArray.length; i += 3) {
                if (blArray[0]) {
                    dArray[i] = Math.log10(dArray[i]);
                }
                if (blArray[1]) {
                    dArray[i + 1] = Math.log10(dArray[i + 1]);
                }
                if (!blArray[2]) continue;
                dArray[i + 2] = Math.log10(dArray[i + 2]);
            }
        }
    }

    public static void toInverseLogScale(double[] dArray, boolean[] blArray) {
        if (blArray[0] || blArray[1] || blArray[2]) {
            for (int i = 0; i < dArray.length; i += 3) {
                if (blArray[0]) {
                    dArray[i] = Math.pow(10.0, dArray[i]);
                }
                if (blArray[1]) {
                    dArray[i + 1] = Math.pow(10.0, dArray[i + 1]);
                }
                if (!blArray[2]) continue;
                dArray[i + 2] = Math.pow(10.0, dArray[i + 2]);
            }
        }
    }

    public static double[] computeIntersection(Integer n, int n2, double[] dArray) {
        double[] dArray2 = (double[])PolylineData.getDataX((int)n);
        double[] dArray3 = (double[])PolylineData.getDataY((int)n);
        double[] dArray4 = (double[])PolylineData.getDataZ((int)n);
        Integer n3 = (Integer)GraphicController.getController().getProperty(n, 32);
        boolean[] blArray = new boolean[]{(Boolean)GraphicController.getController().getProperty(n3, 117), (Boolean)GraphicController.getController().getProperty(n3, 134), (Boolean)GraphicController.getController().getProperty(n3, 151)};
        Axes axes = (Axes)GraphicController.getController().getObjectFromId(n3);
        double[] dArray5 = AxesDrawer.compute3dViewCoordinates(axes, new double[]{dArray[0], dArray[1], 1.0});
        double[] dArray6 = AxesDrawer.compute3dViewCoordinates(axes, new double[]{dArray[0], dArray[1], 0.0});
        double[] dArray7 = new double[]{dArray2[n2], dArray3[n2], dArray4[n2]};
        double[] dArray8 = new double[]{dArray2[n2 + 1], dArray3[n2 + 1], dArray4[n2 + 1]};
        CommonHandler.toLogScale(dArray5, blArray);
        CommonHandler.toLogScale(dArray6, blArray);
        CommonHandler.toLogScale(dArray7, blArray);
        CommonHandler.toLogScale(dArray8, blArray);
        double[] dArray9 = dArray7;
        double[] dArray10 = CommonHandler.minus(dArray8, dArray7);
        double[] dArray11 = dArray5;
        double[] dArray12 = CommonHandler.minus(dArray6, dArray5);
        double[] dArray13 = CommonHandler.cross(dArray12, CommonHandler.cross(dArray10, dArray12));
        double d = (CommonHandler.dot(dArray13, dArray11) - CommonHandler.dot(dArray13, dArray9)) / CommonHandler.dot(dArray13, dArray10);
        double[] dArray14 = CommonHandler.plus(dArray9, CommonHandler.scalar(dArray10, d));
        CommonHandler.toInverseLogScale(dArray14, blArray);
        return new double[]{dArray14[0], dArray14[1], dArray14[2], d, d};
    }

    private static double dot(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    private static double[] cross(double[] dArray, double[] dArray2) {
        return new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
    }

    private static double[] minus(double[] dArray, double[] dArray2) {
        return new double[]{dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]};
    }

    private static double[] plus(double[] dArray, double[] dArray2) {
        return new double[]{dArray[0] + dArray2[0], dArray[1] + dArray2[1], dArray[2] + dArray2[2]};
    }

    private static double[] scalar(double[] dArray, double d) {
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        dArray[2] = dArray[2] * d;
        return dArray;
    }
}

