/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinProgress;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinProgress;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingConstants;

class GtkProgress
extends AbstractSkinProgress
implements SkinProgress,
SwingConstants {
    DefaultButton hprogressBar;
    DefaultButton hprogressBack;
    DefaultButton vprogressBar;
    DefaultButton vprogressBack;

    public Dimension getMinimumSize(JProgressBar progress) {
        if (1 == progress.getOrientation()) {
            if (this.vprogressBack != null) {
                return this.vprogressBack.getMinimumSize();
            }
            return new Dimension(17, 50);
        }
        if (this.hprogressBack != null) {
            return this.hprogressBack.getMinimumSize();
        }
        return new Dimension(50, 17);
    }

    public boolean status() {
        return this.hprogressBar != null;
    }

    public boolean installSkin(JComponent c) {
        return true;
    }

    public boolean paintProgress(Graphics g, JProgressBar progress) {
        if (1 == progress.getOrientation()) {
            if (this.vprogressBack != null) {
                this.vprogressBack.paint(g, 0, 0, progress.getWidth(), progress.getHeight(), progress);
            }
            if (this.vprogressBar != null && progress.getValue() > progress.getMinimum()) {
                int size = (int)((double)progress.getValue() * (double)progress.getHeight() / (double)progress.getMaximum());
                this.vprogressBar.paint(g, 0, progress.getHeight() - size, progress.getWidth(), size, progress);
            }
            return true;
        }
        if (this.hprogressBack != null) {
            this.hprogressBack.paint(g, 0, 0, progress.getWidth(), progress.getHeight(), progress);
        }
        if (this.hprogressBar != null && progress.getValue() > progress.getMinimum()) {
            this.hprogressBar.paint(g, 0, 0, (int)((double)progress.getValue() * (double)progress.getWidth() / (double)progress.getMaximum()), progress.getHeight(), progress);
        }
        return true;
    }

    public GtkProgress(GtkParser parser) throws Exception {
        this.hprogressBar = GtkUtils.newButton(parser, "GtkProgressBar", new String[]{"function", "detail"}, new String[]{"BOX", "bar"});
        this.hprogressBack = GtkUtils.newButton(parser, "GtkProgressBar", new String[]{"function", "detail"}, new String[]{"BOX", "trough"});
        this.vprogressBar = this.hprogressBar.rotateCounterClockWise();
        this.vprogressBack = this.hprogressBack.rotateCounterClockWise();
    }
}

