/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.configuration;

import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.JFileChooser;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.gui.filechooser.FileChooser;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfScicosID;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.configuration.model.DocumentType;
import org.scilab.modules.xcos.configuration.model.ObjectFactory;
import org.scilab.modules.xcos.configuration.model.SettingType;
import org.scilab.modules.xcos.configuration.utils.ConfigurationConstants;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.graph.model.XcosCellFactory;
import org.scilab.modules.xcos.io.XcosFileType;
import org.scilab.modules.xcos.preferences.XcosOptions;
import org.scilab.modules.xcos.utils.FileUtils;
import org.scilab.modules.xcos.utils.XcosMessages;
import org.xml.sax.SAXException;

public final class ConfigurationManager {
    private static final String UNABLE_TO_VALIDATE_CONFIG = "Unable to validate the configuration file.\n";
    private static final String MODEL_CLASS_PACKAGE = "org.scilab.modules.xcos.configuration.model";
    private static final String SCHEMA_FILENAME = "/XcosConfiguration.xsd";
    private static final String INSTANCE_FILENAME = "/xcos.xml";
    private static ConfigurationManager instance;
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private final SettingType settings = this.loadConfig();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    public SettingType getSettings() {
        return this.settings;
    }

    public SettingType loadConfig() {
        try {
            if (unmarshaller == null) {
                this.initUnmarshaller();
            }
            try {
                File file;
                File file2 = new File(String.valueOf(ScilabConstants.SCIHOME.getAbsoluteFile()) + INSTANCE_FILENAME);
                if (!file2.exists()) {
                    file = new File(String.valueOf(ScilabConstants.SCI.getAbsoluteFile()) + "/modules/xcos/etc/xcos.xml");
                    FileUtils.forceCopy(file, file2);
                }
                file = unmarshaller.unmarshal((Source)new StreamSource(file2), SettingType.class);
                return (SettingType)file.getValue();
            }
            catch (JAXBException jAXBException) {
                if (GraphicsEnvironment.isHeadless()) {
                    Logger.getLogger(ConfigurationManager.class.getName()).warning("user configuration file is not valid.\nSwitching to the default one." + String.valueOf((Object)jAXBException));
                } else {
                    ScilabModalDialog.show(null, (String)XcosMessages.ERR_CONFIG_INVALID, (String)XcosMessages.XCOS_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
                }
                try {
                    File file = new File(String.valueOf(ScilabConstants.SCI.getAbsoluteFile()) + "/modules/xcos/etc/xcos.xml");
                    JAXBElement jAXBElement = unmarshaller.unmarshal((Source)new StreamSource(file), SettingType.class);
                    return (SettingType)jAXBElement.getValue();
                }
                catch (JAXBException jAXBException2) {
                    Logger.getLogger(ConfigurationManager.class.getName()).severe("base configuration file corrupted.\n" + String.valueOf((Object)jAXBException2));
                }
            }
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
        return new ObjectFactory().createSettingType();
    }

    private void initUnmarshaller() throws JAXBException {
        String string = ScilabConstants.SCI.getAbsolutePath() + "/modules/xcos/etc/XcosConfiguration.xsd";
        JAXBContext jAXBContext = JAXBContext.newInstance((String)MODEL_CLASS_PACKAGE);
        unmarshaller = jAXBContext.createUnmarshaller();
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new File(string));
            unmarshaller.setSchema(schema);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(ConfigurationManager.class.getName()).severe(UNABLE_TO_VALIDATE_CONFIG + String.valueOf(sAXException));
        }
    }

    public void saveConfig() {
        try {
            if (marshaller == null) {
                this.initMarshaller();
            }
            try {
                File file = new File(String.valueOf(ScilabConstants.SCIHOME.getAbsoluteFile()) + INSTANCE_FILENAME);
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal(new ObjectFactory().createSettings(this.getSettings()), file);
            }
            catch (JAXBException jAXBException) {
                Logger.getLogger(ConfigurationManager.class.getName()).warning("Unable to save user configuration file.\n" + String.valueOf((Object)jAXBException));
            }
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return;
        }
    }

    private void initMarshaller() throws JAXBException {
        String string = ScilabConstants.SCI.getAbsolutePath() + "/modules/xcos/etc/XcosConfiguration.xsd";
        JAXBContext jAXBContext = JAXBContext.newInstance((String)MODEL_CLASS_PACKAGE);
        marshaller = jAXBContext.createMarshaller();
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new File(string));
            marshaller.setSchema(schema);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(ConfigurationManager.class.getName()).warning(UNABLE_TO_VALIDATE_CONFIG + String.valueOf(sAXException));
        }
    }

    public void addToRecentFiles(File file) {
        DatatypeFactory datatypeFactory;
        String string;
        List<DocumentType> list = this.getSettings().getRecent();
        int n = XcosOptions.getPreferences().getNumberOfRecentlyOpen();
        int n2 = list.size() - n;
        for (int i = 0; i < n2; ++i) {
            list.remove(list.size() - 1);
        }
        try {
            string = file.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(ConfigurationManager.class.getName()).severe(malformedURLException.toString());
            return;
        }
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            Logger.getLogger(ConfigurationManager.class.getName()).severe(datatypeConfigurationException.toString());
            return;
        }
        DocumentType documentType = new ObjectFactory().createDocumentType();
        documentType.setUrl(string);
        documentType.setDate(datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar()));
        DocumentType[] documentTypeArray = list.toArray(new DocumentType[list.size()]);
        Arrays.sort(documentTypeArray, ConfigurationConstants.FILENAME_COMPARATOR);
        DocumentType documentType2 = null;
        int n3 = Arrays.binarySearch(documentTypeArray, documentType, ConfigurationConstants.FILENAME_COMPARATOR);
        if (n3 >= 0) {
            documentType2 = documentTypeArray[n3];
            list.remove(documentType2);
        } else if (list.size() == n && list.size() > 0) {
            documentType2 = list.remove(list.size() - 1);
        }
        list.add(0, documentType);
        this.firePropertyChange("recentFilesHasChanged", documentType2, documentType);
    }

    public void addToRecentTabs(XcosDiagram xcosDiagram) {
        DocumentType documentType = this.allocate(xcosDiagram);
        if (xcosDiagram.getSavedFile() != null) {
            try {
                documentType.setUrl(xcosDiagram.getSavedFile().toURI().toURL().toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.savePath(xcosDiagram, documentType);
        documentType.setUuid(xcosDiagram.getGraphTab());
        documentType.setViewport(xcosDiagram.getViewPortTab());
    }

    public Stream<DocumentType> streamTab() {
        return this.getSettings().getTab().stream();
    }

    private DocumentType allocate(XcosDiagram xcosDiagram) {
        List<DocumentType> list = this.getSettings().getTab();
        DocumentType documentType = null;
        for (DocumentType documentType2 : list) {
            if (!documentType2.getUuid().equals(xcosDiagram.getGraphTab())) continue;
            documentType = documentType2;
            break;
        }
        if (documentType == null) {
            documentType = new ObjectFactory().createDocumentType();
            list.add(documentType);
        }
        return documentType;
    }

    public void removeFromRecentTabs(String string) {
        List<DocumentType> list = this.getSettings().getTab();
        boolean bl = false;
        boolean bl2 = false;
        DocumentType documentType = null;
        for (DocumentType documentType2 : list) {
            bl = string.equals(documentType2.getUuid());
            bl2 = string.equals(documentType2.getViewport());
            if (!bl && !bl2) continue;
            documentType = documentType2;
            break;
        }
        if (bl) {
            documentType.setUuid(null);
        } else if (bl2) {
            documentType.setViewport(null);
        }
        if (documentType != null && documentType.getUuid() == null) {
            list.remove(documentType);
        }
    }

    public XcosDiagram loadDiagram(JavaController javaController, DocumentType documentType) {
        String[] stringArray;
        Object object;
        Object object2;
        File file = this.getFile(documentType);
        if (file != null && !file.exists()) {
            file = null;
        }
        Optional<ScicosObjectOwner> optional = Xcos.getInstance().openedDiagram(javaController, file);
        Optional<ScicosObjectOwner> optional2 = this.decodePath(documentType, javaController, optional);
        if (optional.isPresent()) {
            object2 = Xcos.getInstance().openedDiagrams(optional.get()).stream().filter(xcosDiagram -> Objects.equals(xcosDiagram.getGraphTab(), documentType.getUuid())).findFirst();
            if (((Optional)object2).isPresent()) {
                return ((Optional)object2).get();
            }
            object2 = Xcos.getInstance().openedDiagrams(optional.get()).stream().filter(xcosDiagram -> xcosDiagram.getUID() == optional2.map(scicosObjectOwner -> scicosObjectOwner.getUID()).orElse(0L).longValue()).findFirst();
            if (((Optional)object2).isPresent()) {
                return (XcosDiagram)((Object)((Optional)object2).get());
            }
        }
        if (optional.isPresent() && optional == optional2) {
            return this.createDiagram(javaController, optional.get(), optional.get(), "", documentType.getUuid());
        }
        if (optional.isPresent() && optional2.isPresent()) {
            object2 = new String[]{""};
            javaController.getObjectProperty(optional2.get().getUID(), optional2.get().getKind(), ObjectProperties.UID, (String[])object2);
            return this.createDiagram(javaController, optional.get(), optional2.get(), (String)object2[0], documentType.getUuid());
        }
        if (optional.isPresent()) {
            return null;
        }
        object2 = new ScicosObjectOwner(javaController, javaController.createObject(Kind.DIAGRAM), Kind.DIAGRAM);
        XcosDiagram xcosDiagram2 = new XcosDiagram(javaController, ((ScicosObjectOwner)object2).getUID(), ((ScicosObjectOwner)object2).getKind(), "");
        xcosDiagram2.setSavedFile(file);
        try {
            if (file != null) {
                object = file.getCanonicalPath();
                stringArray = XcosFileType.findFileType(file);
                stringArray.load((String)object, xcosDiagram2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.getLogger(ConfigurationManager.class.getName()).log(Level.SEVERE, null, exception);
        }
        object = this.decodePath(documentType, javaController, Optional.of(object2));
        if (((Optional)object).isPresent() && ((Optional)object).get() == object2) {
            xcosDiagram2.installListeners();
            xcosDiagram2.setModified(false);
            Xcos.getInstance().addDiagram((ScicosObjectOwner)object2, xcosDiagram2);
            xcosDiagram2.setGraphTab(documentType.getUuid());
            return xcosDiagram2;
        }
        if (((Optional)object).isPresent()) {
            stringArray = new String[]{""};
            javaController.getObjectProperty(((ScicosObjectOwner)((Optional)object).get()).getUID(), ((ScicosObjectOwner)((Optional)object).get()).getKind(), ObjectProperties.UID, stringArray);
            return this.createDiagram(javaController, (ScicosObjectOwner)object2, (ScicosObjectOwner)((Optional)object).get(), stringArray[0], documentType.getUuid());
        }
        return null;
    }

    private XcosDiagram createDiagram(JavaController javaController, ScicosObjectOwner scicosObjectOwner, ScicosObjectOwner scicosObjectOwner2, String string, String string2) {
        XcosDiagram xcosDiagram = new XcosDiagram(javaController, scicosObjectOwner2, string);
        XcosCellFactory.insertChildren(javaController, xcosDiagram);
        xcosDiagram.installListeners();
        xcosDiagram.setModified(false);
        Xcos.getInstance().addDiagram(scicosObjectOwner, xcosDiagram);
        xcosDiagram.setGraphTab(string2);
        return xcosDiagram;
    }

    public File getFile(DocumentType documentType) {
        File file;
        try {
            URL uRL = new URL(documentType.getUrl());
            file = new File(uRL.toURI());
        }
        catch (Exception exception) {
            return null;
        }
        return file;
    }

    private Optional<ScicosObjectOwner> decodePath(DocumentType documentType, JavaController javaController, Optional<ScicosObjectOwner> optional) {
        String string = documentType.getPath();
        if (string == null || string.isEmpty()) {
            return optional;
        }
        String string2 = documentType.getPath();
        String[] stringArray = new String[]{""};
        VectorOfScicosID vectorOfScicosID = javaController.getAll(Kind.BLOCK);
        int n = vectorOfScicosID.size();
        for (int i = 0; i < n; ++i) {
            javaController.getObjectProperty(vectorOfScicosID.get(i), Kind.BLOCK, ObjectProperties.UID, stringArray);
            if (!string2.equals(stringArray[0])) continue;
            return Optional.of(new ScicosObjectOwner(javaController, vectorOfScicosID.get(i), Kind.BLOCK));
        }
        return Optional.empty();
    }

    private void savePath(XcosDiagram xcosDiagram, DocumentType documentType) {
        if (xcosDiagram.getKind() != Kind.BLOCK) {
            return;
        }
        JavaController javaController = new JavaController();
        String[] stringArray = new String[]{""};
        javaController.getObjectProperty(xcosDiagram.getUID(), Kind.BLOCK, ObjectProperties.UID, stringArray);
        documentType.setPath(stringArray[0]);
    }

    public static void configureCurrentDirectory(Object object) {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        Iterator<DocumentType> iterator = configurationManager.getSettings().getRecent().iterator();
        File file = null;
        if (iterator.hasNext()) {
            try {
                file = new File(new URL(iterator.next().getUrl()).toURI());
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (file != null) {
            if (object instanceof JFileChooser) {
                ((JFileChooser)object).setCurrentDirectory(file);
            } else if (object instanceof FileChooser) {
                ((FileChooser)object).setInitialDirectory(file.getPath());
            }
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.changeSupport.firePropertyChange(string, object, object2);
    }
}

