/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.graph;

import java.beans.PropertyVetoException;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.VectorOfString;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.io.ScilabTypeCoder;
import org.scilab.modules.xcos.preferences.XcosOptions;
import org.scilab.modules.xcos.utils.Stack;

public class ScicosParameters
implements Serializable,
Cloneable {
    public static final String FINAL_INTEGRATION_TIME_CHANGE = "finalIntegrationTime";
    public static final String INTEGRATOR_ABSOLUTE_TOLERANCE_CHANGE = "integratorAbsoluteTolerance";
    public static final String INTEGRATOR_RELATIVE_TOLERANCE_CHANGE = "integratorRelativeTolerance";
    public static final String TOLERANCE_ON_TIME_CHANGE = "toleranceOnTime";
    public static final String MAX_INTEGRATION_TIME_INTERVAL_CHANGE = "maxIntegrationTimeInterval";
    public static final String REAL_TIME_SCALING_CHANGE = "realTimeScaling";
    public static final String SOLVER_CHANGE = "solver";
    public static final String MAXIMUM_STEP_SIZE_CHANGE = "maximumStepSize";
    public static final String DEBUG_LEVEL_CHANGE = "debugLevel";
    public static final String CONTEXT_CHANGE = "context";
    public static final int FINAL_INTEGRATION_TIME = 0;
    public static final int INTEGRATOR_ABSOLUTE_TOLERANCE = 1;
    public static final int INTEGRATOR_RELATIVE_TOLERANCE = 2;
    public static final int TOLERANCE_ON_TIME = 3;
    public static final int MAX_INTEGRATION_TIME_INTERVAL = 4;
    public static final int REAL_TIME_SCALING = 5;
    public static final int SOLVER = 6;
    public static final int MAXIMUM_STEP_SIZE = 7;
    public static VectorOfDouble DEFAULT_PARAMETERS;
    public static int DEFAULT_DEBUG_LEVEL;
    private final ScicosObjectOwner root;
    private final ScicosObjectOwner current;
    private final VetoableChangeSupport vcs = new VetoableChangeSupport(this);

    public ScicosParameters(ScicosObjectOwner scicosObjectOwner, ScicosObjectOwner scicosObjectOwner2) {
        this.root = scicosObjectOwner;
        this.current = scicosObjectOwner2;
        XcosOptions.getSimulation();
        this.vcs.addVetoableChangeListener(propertyChangeEvent -> {
            Xcos xcos = Xcos.getInstance();
            if (!xcos.openedDiagrams(scicosObjectOwner).isEmpty()) {
                xcos.setModified(scicosObjectOwner, true);
                xcos.openedDiagrams(scicosObjectOwner).stream().forEach(xcosDiagram -> xcosDiagram.updateTabTitle());
            }
        });
    }

    public ScicosObjectOwner getRoot() {
        return this.root;
    }

    public ScicosObjectOwner getCurrent() {
        return this.current;
    }

    public VectorOfDouble getProperties(JavaController javaController) {
        VectorOfDouble vectorOfDouble = new VectorOfDouble(7L);
        javaController.getObjectProperty(this.root.getUID(), this.root.getKind(), ObjectProperties.PROPERTIES, vectorOfDouble);
        return vectorOfDouble;
    }

    public void setProperties(JavaController javaController, VectorOfDouble vectorOfDouble) throws PropertyVetoException {
        VectorOfDouble vectorOfDouble2 = this.getProperties(javaController);
        this.vcs.fireVetoableChange(FINAL_INTEGRATION_TIME_CHANGE, vectorOfDouble2, vectorOfDouble);
        javaController.setObjectProperty(this.root.getUID(), this.root.getKind(), ObjectProperties.PROPERTIES, vectorOfDouble);
    }

    public VectorOfString getContext(JavaController javaController) {
        VectorOfString vectorOfString = new VectorOfString();
        javaController.getObjectProperty(this.current.getUID(), this.current.getKind(), ObjectProperties.DIAGRAM_CONTEXT, vectorOfString);
        return vectorOfString;
    }

    public void setContext(JavaController javaController, VectorOfString vectorOfString) throws PropertyVetoException {
        VectorOfString vectorOfString2 = this.getContext(javaController);
        this.vcs.fireVetoableChange(CONTEXT_CHANGE, vectorOfString2, vectorOfString);
        javaController.setObjectProperty(this.current.getUID(), this.current.getKind(), ObjectProperties.DIAGRAM_CONTEXT, vectorOfString);
    }

    public String getVersion(JavaController javaController) {
        String[] stringArray = new String[1];
        javaController.getObjectProperty(this.root.getUID(), this.root.getKind(), ObjectProperties.VERSION_NUMBER, stringArray);
        return stringArray[0];
    }

    public int getDebugLevel(JavaController javaController) {
        int[] nArray = new int[1];
        javaController.getObjectProperty(this.root.getUID(), this.root.getKind(), ObjectProperties.DEBUG_LEVEL, nArray);
        return nArray[0];
    }

    public void setDebugLevel(JavaController javaController, int n) throws PropertyVetoException {
        int n2 = this.getDebugLevel(javaController);
        this.vcs.fireVetoableChange(DEBUG_LEVEL_CHANGE, n2, n);
        javaController.setObjectProperty(this.root.getUID(), this.root.getKind(), ObjectProperties.DEBUG_LEVEL, n);
    }

    public Stack<ScicosObjectOwner> lookForHierarchy(JavaController javaController) {
        Stack<ScicosObjectOwner> stack = new Stack<ScicosObjectOwner>();
        long[] lArray = new long[]{this.current.getUID()};
        if (this.current.getKind() == Kind.DIAGRAM) {
            stack.push(this.current);
            return stack;
        }
        while (lArray[0] != 0L) {
            stack.push(new ScicosObjectOwner(javaController, lArray[0], Kind.BLOCK));
            javaController.getObjectProperty(lArray[0], Kind.BLOCK, ObjectProperties.PARENT_BLOCK, lArray);
        }
        javaController.getObjectProperty(this.current.getUID(), this.current.getKind(), ObjectProperties.PARENT_DIAGRAM, lArray);
        stack.push(new ScicosObjectOwner(javaController, lArray[0], Kind.DIAGRAM));
        return stack;
    }

    public String[] getAllContext(JavaController javaController) {
        ArrayList arrayList = new ArrayList();
        Stack<ScicosObjectOwner> stack = this.lookForHierarchy(javaController);
        VectorOfString vectorOfString = new VectorOfString();
        stack.stream().forEach(scicosObjectOwner -> {
            ScilabList scilabList;
            ScilabType scilabType;
            javaController.getObjectProperty(scicosObjectOwner.getUID(), scicosObjectOwner.getKind(), ObjectProperties.DIAGRAM_CONTEXT, vectorOfString);
            int n = vectorOfString.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(vectorOfString.get(i));
            }
            arrayList.add("");
            VectorOfDouble vectorOfDouble = new VectorOfDouble();
            javaController.getObjectProperty(scicosObjectOwner.getUID(), scicosObjectOwner.getKind(), ObjectProperties.EXPRS, vectorOfDouble);
            if (vectorOfDouble.size() > 0 && (scilabType = new ScilabTypeCoder().vec2var(vectorOfDouble)) instanceof ScilabList && (scilabList = (ScilabList)scilabType).size() == 2 && scilabList.get(0) instanceof ScilabString && scilabList.get(1) instanceof ScilabList) {
                ScilabString scilabString = (ScilabString)scilabList.get(0);
                ScilabList scilabList2 = (ScilabList)scilabList.get(1);
                if (scilabList2.size() > 1 && scilabList2.get(0) instanceof ScilabString) {
                    ScilabString scilabString2 = (ScilabString)scilabList2.get(0);
                    if (scilabString.getHeight() == scilabString2.getHeight()) {
                        for (int i = 0; i < scilabString.getHeight(); ++i) {
                            arrayList.add(scilabString2.getData()[i][0] + " = " + scilabString.getData()[i][0]);
                        }
                    }
                }
            }
        });
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

