/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import java.rmi.server.UID;
import java.util.List;
import org.scilab.modules.graph.utils.StyleMap;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.io.scicos.AbstractElement;
import org.scilab.modules.xcos.io.scicos.BlockElement;
import org.scilab.modules.xcos.io.scicos.BlockGraphicElement;
import org.scilab.modules.xcos.io.scicos.BlockModelElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.scilab.modules.xcos.port.input.ExplicitInputPort;
import org.scilab.modules.xcos.port.input.ImplicitInputPort;
import org.scilab.modules.xcos.port.input.InputPort;

public final class InputPortElement
extends AbstractElement<InputPort> {
    protected static final List<String> DATA_FIELD_NAMES = BlockElement.DATA_FIELD_NAMES;
    protected static final List<String> GRAPHICS_DATA_FIELD_NAMES_FULL = BlockGraphicElement.DATA_FIELD_NAMES_FULL;
    protected static final List<String> MODEL_DATA_FIELD_NAMES = BlockModelElement.DATA_FIELD_NAMES;
    private static final int GRAPHICS_INDEX = DATA_FIELD_NAMES.indexOf("graphics");
    private static final int MODEL_INDEX = DATA_FIELD_NAMES.indexOf("model");
    private static final int GRAPHICS_PIN_INDEX = GRAPHICS_DATA_FIELD_NAMES_FULL.indexOf("pin");
    private static final int GRAPHICS_INIMPL_INDEX = GRAPHICS_DATA_FIELD_NAMES_FULL.indexOf("in_implicit");
    private static final int GRAPHICS_INSTYLE_INDEX = GRAPHICS_DATA_FIELD_NAMES_FULL.indexOf("in_style");
    private static final int GRAPHICS_INLABEL_INDEX = GRAPHICS_DATA_FIELD_NAMES_FULL.indexOf("in_label");
    private static final int MODEL_IN_DATALINE_INDEX = MODEL_DATA_FIELD_NAMES.indexOf("in");
    private static final int MODEL_IN_DATACOL_INDEX = MODEL_DATA_FIELD_NAMES.indexOf("in2");
    private static final int MODEL_IN_DATATYPE_INDEX = MODEL_DATA_FIELD_NAMES.indexOf("intyp");
    private static final String EXPLICIT = "E";
    private static final String IMPLICIT = "I";
    private ScilabMList data;
    private final ScilabMList graphics;
    private final ScilabMList model;
    private int alreadyDecodedCount;
    private boolean allColumnsAreZeros = true;

    public InputPortElement(JavaController javaController, ScilabType scilabType) {
        super(javaController);
        this.data = (ScilabMList)scilabType;
        this.graphics = (ScilabMList)this.data.get(GRAPHICS_INDEX);
        this.model = (ScilabMList)this.data.get(MODEL_INDEX);
    }

    public int getNumberOfInputPort() {
        return ((ScilabType)this.model.get(MODEL_IN_DATALINE_INDEX)).getHeight();
    }

    @Override
    public InputPort decode(ScilabType scilabType, InputPort inputPort) throws ScicosFormatException {
        this.data = (ScilabMList)scilabType;
        InputPort inputPort2 = this.allocatePort();
        inputPort2.setId(new UID().toString());
        inputPort2 = this.beforeDecode(scilabType, inputPort2);
        this.decodeModel(inputPort2);
        this.decodeGraphics(inputPort2);
        ++this.alreadyDecodedCount;
        inputPort2 = this.afterDecode(scilabType, inputPort2);
        return inputPort2;
    }

    private InputPort allocatePort() {
        if (this.graphics.size() <= GRAPHICS_INIMPL_INDEX) {
            return new ExplicitInputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null);
        }
        ScilabType scilabType = (ScilabType)this.graphics.get(GRAPHICS_INIMPL_INDEX);
        if (InputPortElement.isEmptyField(scilabType)) {
            return new ExplicitInputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null);
        }
        ScilabString scilabString = (ScilabString)scilabType;
        if (InputPortElement.isEmptyField((ScilabType)scilabString)) {
            return new ExplicitInputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null);
        }
        boolean bl = scilabString.getHeight() >= scilabString.getWidth();
        int[] nArray = InputPortElement.getIndexes(this.alreadyDecodedCount, bl);
        String[][] stringArray = scilabString.getData();
        boolean bl2 = InputPortElement.canGet((ScilabType)scilabString, nArray);
        InputPort inputPort = bl2 && stringArray[nArray[0]][nArray[1]].equals(EXPLICIT) ? new ExplicitInputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null) : (bl2 && stringArray[nArray[0]][nArray[1]].equals(IMPLICIT) ? new ImplicitInputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null) : new ExplicitInputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null));
        return inputPort;
    }

    private void decodeModel(InputPort inputPort) {
        int n;
        int n2;
        ScilabDouble scilabDouble = (ScilabDouble)this.model.get(MODEL_IN_DATALINE_INDEX);
        ScilabDouble scilabDouble2 = (ScilabDouble)this.model.get(MODEL_IN_DATACOL_INDEX);
        ScilabDouble scilabDouble3 = (ScilabDouble)this.model.get(MODEL_IN_DATATYPE_INDEX);
        int n3 = scilabDouble.getRealPart() != null ? (int)scilabDouble.getRealPart()[this.alreadyDecodedCount][0] : 1;
        if (scilabDouble2.getRealPart() != null) {
            try {
                n2 = (int)scilabDouble2.getRealPart()[this.alreadyDecodedCount][0];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n2 = 1;
            }
        } else {
            n2 = 1;
        }
        if (scilabDouble3.getRealPart() != null) {
            try {
                n = (int)scilabDouble3.getRealPart()[this.alreadyDecodedCount][0];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n = 1;
            }
        } else {
            n = 1;
        }
        VectorOfInt vectorOfInt = new VectorOfInt(3L);
        vectorOfInt.set(0, n3);
        vectorOfInt.set(1, n2);
        vectorOfInt.set(2, n);
        this.controller.setObjectProperty(inputPort.getUID(), inputPort.getKind(), ObjectProperties.DATATYPE, vectorOfInt);
    }

    private void decodeGraphics(InputPort inputPort) {
        String string;
        boolean bl;
        int[] nArray;
        ScilabString scilabString;
        if (this.graphics.size() > GRAPHICS_INSTYLE_INDEX && !InputPortElement.isEmptyField((ScilabType)this.graphics.get(GRAPHICS_INSTYLE_INDEX)) && InputPortElement.canGet((ScilabType)scilabString, nArray = InputPortElement.getIndexes(this.alreadyDecodedCount, bl = (scilabString = (ScilabString)this.graphics.get(GRAPHICS_INSTYLE_INDEX)).getHeight() >= scilabString.getWidth()))) {
            string = scilabString.getData()[nArray[0]][nArray[1]];
            inputPort.setStyle(new StyleMap(inputPort.getStyle()).putAll(string).toString());
        }
        if (this.graphics.size() > GRAPHICS_INLABEL_INDEX && !InputPortElement.isEmptyField((ScilabType)this.graphics.get(GRAPHICS_INLABEL_INDEX)) && InputPortElement.canGet((ScilabType)scilabString, nArray = InputPortElement.getIndexes(this.alreadyDecodedCount, bl = (scilabString = (ScilabString)this.graphics.get(GRAPHICS_INLABEL_INDEX)).getHeight() >= scilabString.getWidth()))) {
            string = scilabString.getData()[nArray[0]][nArray[1]];
            if (string != null) {
                inputPort.setValue(string);
            } else {
                inputPort.setValue("");
            }
        }
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        this.data = (ScilabMList)scilabType;
        String string = ((ScilabString)this.data.get(0)).getData()[0][0];
        return string.equals(DATA_FIELD_NAMES.get(0)) && this.getNumberOfInputPort() > this.alreadyDecodedCount;
    }
}

