/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import java.rmi.server.UID;
import java.util.List;
import org.scilab.modules.graph.utils.StyleMap;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabMList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfInt;
import org.scilab.modules.xcos.io.scicos.AbstractElement;
import org.scilab.modules.xcos.io.scicos.BlockElement;
import org.scilab.modules.xcos.io.scicos.BlockGraphicElement;
import org.scilab.modules.xcos.io.scicos.BlockModelElement;
import org.scilab.modules.xcos.io.scicos.ScicosFormatException;
import org.scilab.modules.xcos.port.output.ExplicitOutputPort;
import org.scilab.modules.xcos.port.output.ImplicitOutputPort;
import org.scilab.modules.xcos.port.output.OutputPort;

public final class OutputPortElement
extends AbstractElement<OutputPort> {
    protected static final List<String> DATA_FIELD_NAMES = BlockElement.DATA_FIELD_NAMES;
    protected static final List<String> GRAPHICS_DATA_FIELD_NAMES_FULL = BlockGraphicElement.DATA_FIELD_NAMES_FULL;
    protected static final List<String> MODEL_DATA_FIELD_NAMES = BlockModelElement.DATA_FIELD_NAMES;
    private static final int GRAPHICS_INDEX = DATA_FIELD_NAMES.indexOf("graphics");
    private static final int MODEL_INDEX = DATA_FIELD_NAMES.indexOf("model");
    private static final int GRAPHICS_POUT_INDEX = GRAPHICS_DATA_FIELD_NAMES_FULL.indexOf("pout");
    private static final int GRAPHICS_OUTIMPL_INDEX = GRAPHICS_DATA_FIELD_NAMES_FULL.indexOf("out_implicit");
    private static final int GRAPHICS_OUTSTYLE_INDEX = GRAPHICS_DATA_FIELD_NAMES_FULL.indexOf("out_style");
    private static final int GRAPHICS_OUTLABEL_INDEX = GRAPHICS_DATA_FIELD_NAMES_FULL.indexOf("out_label");
    private static final int MODEL_OUT_DATALINE_INDEX = MODEL_DATA_FIELD_NAMES.indexOf("out");
    private static final int MODEL_OUT_DATACOL_INDEX = MODEL_DATA_FIELD_NAMES.indexOf("out2");
    private static final int MODEL_OUT_DATATYPE_INDEX = MODEL_DATA_FIELD_NAMES.indexOf("outtyp");
    private static final String EXPLICIT = "E";
    private static final String IMPLICIT = "I";
    private ScilabMList data;
    private final ScilabMList graphics;
    private final ScilabMList model;
    private int alreadyDecodedCount;
    private boolean allColumnsAreZeros = true;

    public OutputPortElement(JavaController javaController, ScilabType scilabType) {
        super(javaController);
        this.data = (ScilabMList)scilabType;
        this.graphics = (ScilabMList)this.data.get(GRAPHICS_INDEX);
        this.model = (ScilabMList)this.data.get(MODEL_INDEX);
    }

    public int getNumberOfOutputPort() {
        return ((ScilabType)this.model.get(MODEL_OUT_DATALINE_INDEX)).getHeight();
    }

    @Override
    public OutputPort decode(ScilabType scilabType, OutputPort outputPort) throws ScicosFormatException {
        this.data = (ScilabMList)scilabType;
        OutputPort outputPort2 = this.allocatePort();
        outputPort2.setId(new UID().toString());
        outputPort2 = this.beforeDecode(scilabType, outputPort2);
        this.decodeModel(outputPort2);
        this.decodeGraphics(outputPort2);
        ++this.alreadyDecodedCount;
        outputPort2 = this.afterDecode(scilabType, outputPort2);
        return outputPort2;
    }

    private OutputPort allocatePort() {
        if (this.graphics.size() <= GRAPHICS_OUTIMPL_INDEX) {
            return new ExplicitOutputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null);
        }
        ScilabType scilabType = (ScilabType)this.graphics.get(GRAPHICS_OUTIMPL_INDEX);
        if (OutputPortElement.isEmptyField(scilabType)) {
            return new ExplicitOutputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null);
        }
        ScilabString scilabString = (ScilabString)scilabType;
        if (OutputPortElement.isEmptyField((ScilabType)scilabString)) {
            return new ExplicitOutputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null);
        }
        boolean bl = scilabString.getHeight() >= scilabString.getWidth();
        int[] nArray = OutputPortElement.getIndexes(this.alreadyDecodedCount, bl);
        String[][] stringArray = scilabString.getData();
        boolean bl2 = OutputPortElement.canGet((ScilabType)scilabString, nArray);
        OutputPort outputPort = bl2 && stringArray[nArray[0]][nArray[1]].equals(EXPLICIT) ? new ExplicitOutputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null) : (bl2 && stringArray[nArray[0]][nArray[1]].equals(IMPLICIT) ? new ImplicitOutputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null) : new ExplicitOutputPort(this.controller, this.controller.createObject(Kind.PORT), Kind.PORT, null, null, null));
        return outputPort;
    }

    private void decodeModel(OutputPort outputPort) {
        int n;
        int n2;
        ScilabDouble scilabDouble = (ScilabDouble)this.model.get(MODEL_OUT_DATALINE_INDEX);
        ScilabDouble scilabDouble2 = (ScilabDouble)this.model.get(MODEL_OUT_DATACOL_INDEX);
        ScilabDouble scilabDouble3 = (ScilabDouble)this.model.get(MODEL_OUT_DATATYPE_INDEX);
        int n3 = scilabDouble.getRealPart() != null ? (int)scilabDouble.getRealPart()[this.alreadyDecodedCount][0] : 1;
        if (scilabDouble2.getRealPart() != null) {
            try {
                n2 = (int)scilabDouble2.getRealPart()[this.alreadyDecodedCount][0];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n2 = 1;
            }
        } else {
            n2 = 1;
        }
        if (scilabDouble3.getRealPart() != null) {
            try {
                n = (int)scilabDouble3.getRealPart()[this.alreadyDecodedCount][0];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n = 1;
            }
        } else {
            n = 1;
        }
        VectorOfInt vectorOfInt = new VectorOfInt(3L);
        vectorOfInt.set(0, n3);
        vectorOfInt.set(1, n2);
        vectorOfInt.set(2, n);
        this.controller.setObjectProperty(outputPort.getUID(), outputPort.getKind(), ObjectProperties.DATATYPE, vectorOfInt);
    }

    private void decodeGraphics(OutputPort outputPort) {
        String string;
        boolean bl;
        int[] nArray;
        ScilabString scilabString;
        if (this.graphics.size() > GRAPHICS_OUTSTYLE_INDEX && !OutputPortElement.isEmptyField((ScilabType)this.graphics.get(GRAPHICS_OUTSTYLE_INDEX)) && OutputPortElement.canGet((ScilabType)scilabString, nArray = OutputPortElement.getIndexes(this.alreadyDecodedCount, bl = (scilabString = (ScilabString)this.graphics.get(GRAPHICS_OUTSTYLE_INDEX)).getHeight() >= scilabString.getWidth()))) {
            string = scilabString.getData()[nArray[0]][nArray[1]];
            outputPort.setStyle(new StyleMap(outputPort.getStyle()).putAll(string).toString());
        }
        if (this.graphics.size() > GRAPHICS_OUTLABEL_INDEX && !OutputPortElement.isEmptyField((ScilabType)this.graphics.get(GRAPHICS_OUTLABEL_INDEX)) && OutputPortElement.canGet((ScilabType)scilabString, nArray = OutputPortElement.getIndexes(this.alreadyDecodedCount, bl = (scilabString = (ScilabString)this.graphics.get(GRAPHICS_OUTLABEL_INDEX)).getHeight() >= scilabString.getWidth()))) {
            string = scilabString.getData()[nArray[0]][nArray[1]];
            if (string != null) {
                outputPort.setValue(string);
            } else {
                outputPort.setValue("");
            }
        }
    }

    @Override
    public boolean canDecode(ScilabType scilabType) {
        this.data = (ScilabMList)scilabType;
        String string = ((ScilabString)this.data.get(0)).getData()[0][0];
        return string.equals(DATA_FIELD_NAMES.get(0)) && this.getNumberOfOutputPort() > this.alreadyDecodedCount;
    }
}

