/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.spec;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.xcos.io.spec.Entry;
import org.scilab.modules.xcos.io.spec.XcosPackage;
import org.w3c.dom.Element;

public class DictionaryEntry
implements Entry {
    private static final Logger LOG = Logger.getLogger(DictionaryEntry.class.getName());
    private XcosPackage pack;

    @Override
    public String getMediaType() {
        return "bin/ser";
    }

    @Override
    public String getFullPath() {
        return "dictionary/dictionary.ser";
    }

    @Override
    public void setup(XcosPackage xcosPackage) {
        this.pack = xcosPackage;
    }

    @Override
    public void load(ZipEntry zipEntry, InputStream inputStream, String string) throws IOException {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
            this.pack.getDictionary().clear();
            this.pack.getDictionary().addAll((Collection)((ScilabList)objectInputStream.readObject()));
        }
        catch (IOException | ClassNotFoundException exception) {
            Logger.getLogger(DictionaryEntry.class.getName()).severe(exception.getMessage());
        }
    }

    @Override
    public void store(ZipOutputStream zipOutputStream) throws IOException {
        LOG.entering("ObjectOutputStream", "writeObject");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(zipOutputStream));
        objectOutputStream.writeObject(this.pack.getDictionary());
        objectOutputStream.flush();
        LOG.exiting("ObjectOutputStream", "writeObject");
        Element element = this.pack.getManifest().createElement("manifest:file-entry");
        element.setAttribute("manifest:media-type", this.getMediaType());
        element.setAttribute("manifest:full-path", this.getFullPath());
        this.pack.getManifest().getFirstChild().appendChild(element);
    }
}

