/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.utils;

import java.awt.Dimension;
import org.scilab.modules.graph.utils.ScilabGraphConstants;

public final class XcosConstants
extends ScilabGraphConstants {
    public static final double PALETTE_BLOCK_ICON_RATIO = 1.5;
    public static final int PALETTE_HMARGIN = 5;
    public static final int PALETTE_VMARGIN = 5;
    public static final int MAX_CHAR_IN_STYLE = 37;
    public static final int HISTORY_LENGTH = 20;
    public static final int MAX_HITS = 150;
    public static final String XCOS_ETC = "/modules/xcos/etc";

    private XcosConstants() {
    }

    public static enum PaletteBlockSize {
        TINY,
        SMALL,
        NORMAL,
        LARGE,
        XLARGE;

        private static final Dimension DIM_TINY;
        private static final Dimension DIM_SMALL;
        private static final Dimension DIM_NORMAL;
        private static final Dimension DIM_LARGE;
        private static final Dimension DIM_XLARGE;

        public int getFontSize() {
            switch (this) {
                case TINY: {
                    return 10;
                }
                case SMALL: {
                    return 11;
                }
                case NORMAL: {
                    return 12;
                }
                case LARGE: {
                    return 13;
                }
                case XLARGE: {
                    return 13;
                }
            }
            return 12;
        }

        public int getMaxIconHeight() {
            return (int)((float)this.getBlockDimension().height * 0.65f);
        }

        public int getMaxIconWidth() {
            return (int)((float)this.getBlockDimension().width * 0.65f);
        }

        public Dimension getBlockDimension() {
            switch (this) {
                case TINY: {
                    return DIM_TINY;
                }
                case SMALL: {
                    return DIM_SMALL;
                }
                case NORMAL: {
                    return DIM_NORMAL;
                }
                case LARGE: {
                    return DIM_LARGE;
                }
                case XLARGE: {
                    return DIM_XLARGE;
                }
            }
            return DIM_NORMAL;
        }

        public PaletteBlockSize next() {
            if (this.ordinal() < PaletteBlockSize.values().length - 1) {
                return PaletteBlockSize.values()[this.ordinal() + 1];
            }
            return null;
        }

        public PaletteBlockSize previous() {
            if (this.ordinal() > 0) {
                return PaletteBlockSize.values()[this.ordinal() - 1];
            }
            return null;
        }

        static {
            DIM_TINY = new Dimension(50, 50);
            DIM_SMALL = new Dimension(75, 75);
            DIM_NORMAL = new Dimension(100, 100);
            DIM_LARGE = new Dimension(120, 120);
            DIM_XLARGE = new Dimension(140, 140);
        }
    }
}

