/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.external;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import org.scilab.modules.helptools.HTMLDocbookTagConverter;
import org.scilab.modules.helptools.external.ExternalXMLHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class HTMLScilabHandler
extends ExternalXMLHandler {
    private static final String IMAGE = "image";
    private static final String BASENAME = "_";
    private StringBuilder buffer = new StringBuilder(8192);
    private String baseDir;
    private String outputDir;
    private Boolean isLocalized;
    private int line;

    public HTMLScilabHandler(String string, String string2) {
        this.outputDir = string + File.separator + string2;
        this.baseDir = string2 + "/";
    }

    @Override
    public String getURI() {
        return "http://www.scilab.org";
    }

    @Override
    public StringBuilder startExternalXML(String string, Attributes attributes, Locator locator) {
        if (string.equals(IMAGE)) {
            this.isLocalized = HTMLScilabHandler.getLocalized(null, attributes);
            this.line = locator.getLineNumber();
        }
        if (IMAGE.equals(string)) {
            return this.buffer;
        }
        this.recreateTag(this.buffer, string, attributes);
        return null;
    }

    @Override
    public String endExternalXML(String string) {
        if (IMAGE.equals(string)) {
            String string2;
            File file;
            String string3 = this.getConverter().getCurrentFileName();
            String string4 = new File(string3).getName();
            int n = string4.lastIndexOf(46);
            if (n != -1) {
                string4 = string4.substring(0, n);
            }
            String string5 = ((HTMLDocbookTagConverter)this.getConverter()).getLanguage();
            String string6 = this.isLocalized != null && this.isLocalized != false ? string4 + BASENAME + string5 + BASENAME + this.compt++ + ".png" : string4 + BASENAME + this.compt++ + ".png";
            File file2 = new File(this.outputDir, string6);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string7 = "";
            if (this.getConverter() instanceof HTMLDocbookTagConverter) {
                string7 = ((HTMLDocbookTagConverter)this.getConverter()).getBaseImagePath();
            }
            if (this.isLocalized != null && this.isLocalized.booleanValue() || (file = HTMLScilabHandler.getExistingFile(this.outputDir, string6)) == null) {
                if (!string5.equals("en_US") && !this.getConverter().getImageConverter().compareMD5(this.buffer.toString(), string6) && this.isLocalized == null) {
                    if (this.getConverter().getImageConverter().hasMd5Cache()) {
                        this.getConverter().error(new SAXParseException("Overwrite image " + file2.getName() + " from line " + this.line + ". Check the code or use localized=\"true\" attribute.", null));
                    } else {
                        System.err.println("Warning: Overwrite image " + file2.getName() + " from line " + this.line + ". Check the code or use localized=\"true\" attribute.");
                    }
                }
                string2 = this.getConverter().getImageConverter().getImageByCode(string3, this.buffer.toString(), hashMap, "image/scilab", file2, this.baseDir + file2.getName(), string7, this.line, string5, this.isLocalized);
            } else {
                string2 = this.getConverter().getImageConverter().getImageByFile(hashMap, null, file.getAbsolutePath(), this.outputDir, ".", string7);
            }
            this.buffer.setLength(0);
            return string2;
        }
        this.recreateTag(this.buffer, string, null);
        this.buffer.setLength(0);
        return null;
    }

    private static File getExistingFile(String string, String string2) {
        try {
            final File file = new File(string).getCanonicalFile();
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file2) {
                    return file2.isDirectory() && !file2.equals(file);
                }
            };
            File[] fileArray = file.getParentFile().listFiles(fileFilter);
            File file2 = new File(string2);
            for (File file3 : fileArray) {
                File file4 = new File(file3, file2.getName());
                if (!file4.exists() || !file4.canRead()) continue;
                return file4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

