/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.commons.xml;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.ScilabGeneralPrefs;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.scilab.modules.commons.xml.ScilabTransformerFactory;
import org.scilab.modules.commons.xml.ScilabXMLUtilities;
import org.scilab.modules.commons.xml.ScilabXPathFactory;
import org.scilab.modules.commons.xml.XConfigurationEvent;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.localization.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XConfiguration {
    private static final String SCI = System.getenv("SCI");
    private static final String SCILAB_CONFIG_FILE = SCI + "/modules/preferences/etc/XConfiguration.xml";
    private static final String ERROR_READ = Messages.gettext((String)"Could not load file: ");
    private static final String ERROR_WRITE = Messages.gettext((String)"Could not write the file: ");
    private static final String SEVERE_ERROR = Messages.gettext((String)"A severe error occurred: cannot load the preferences file.");
    private static final String PARSING_ERROR = Messages.gettext((String)"An error occurred when loading the preferences file, try to reload the default one.");
    private static final XPathFactory xpathFactory = ScilabXPathFactory.newInstance();
    private static final Map<Class<?>, StringParser> conv = new HashMap();
    private static final EventListenerList listenerList = new EventListenerList();
    private static final Set<String> modifiedPaths = new HashSet<String>();
    private static Document doc;
    private static boolean hasBeenRead;
    private static boolean mustSave;
    private static String USER_CONFIG_FILE;

    public static Document getXConfigurationDocument() {
        if (doc == null) {
            boolean bl = false;
            File file = new File(USER_CONFIG_FILE);
            if (!file.exists() && mustSave) {
                ScilabXMLUtilities.writeDocument(XConfiguration.createDocument(), USER_CONFIG_FILE);
            }
            DocumentBuilder documentBuilder = null;
            if (mustSave) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = ScilabDocumentBuilderFactory.newInstance();
                    documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    doc = documentBuilder.parse(file);
                    float f = XConfiguration.getDocumentVersion(doc);
                    float f2 = XConfiguration.getDocumentVersion(XConfiguration.getDefaultDocument());
                    if (f2 != f) {
                        file.delete();
                        doc = null;
                        return XConfiguration.getXConfigurationDocument();
                    }
                    return doc;
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    bl = true;
                }
                catch (SAXException sAXException) {
                    bl = true;
                }
                catch (IOException iOException) {
                    bl = true;
                }
                if (bl) {
                    if (hasBeenRead) {
                        System.err.println(SEVERE_ERROR);
                        doc = null;
                        file.delete();
                        return documentBuilder.newDocument();
                    }
                    hasBeenRead = true;
                    doc = null;
                    file.delete();
                    System.err.println(PARSING_ERROR);
                    return XConfiguration.getXConfigurationDocument();
                }
                return documentBuilder.newDocument();
            }
            doc = XConfiguration.createDocument();
        }
        return doc;
    }

    public static void writeDocument(String string, Node node) {
        if (mustSave) {
            Transformer transformer = null;
            try {
                transformer = ScilabTransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                System.err.println(ERROR_WRITE + string);
                return;
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                System.err.println(ERROR_WRITE + string);
                return;
            }
            transformer.setOutputProperty("indent", "yes");
            ScilabXMLUtilities.removeEmptyLines(node);
            StreamResult streamResult = new StreamResult(new File(string));
            DOMSource dOMSource = new DOMSource(node);
            try {
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerException transformerException) {
                System.err.println(ERROR_WRITE + string);
                return;
            }
            if (string.equals(USER_CONFIG_FILE)) {
                doc = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpNode(Node node) {
        Transformer transformer = null;
        try {
            transformer = ScilabTransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.err.println("Cannot dump xml");
            return "";
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            System.err.println("Cannot dump xml");
            return "";
        }
        transformer.setOutputProperty("indent", "yes");
        ScilabXMLUtilities.removeEmptyLines(node);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(new BufferedOutputStream(byteArrayOutputStream));
        DOMSource dOMSource = new DOMSource(node);
        String string = "";
        try {
            transformer.transform(dOMSource, streamResult);
            string = byteArrayOutputStream.toString("UTF-8");
        }
        catch (TransformerException transformerException) {
            System.err.println("Cannot dump xml");
            String string2 = string;
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    private static float getDocumentVersion(Document document) {
        if (document != null) {
            Element element = document.getDocumentElement();
            String string = element.getAttribute("version");
            try {
                return Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    private static Document getDefaultDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = ScilabDocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(SCILAB_CONFIG_FILE);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Cannot create a XML DocumentBuilder:\n" + String.valueOf(parserConfigurationException));
            return null;
        }
        catch (SAXException sAXException) {
            System.err.println("Weird... Cannot parse basic file:\n" + String.valueOf(sAXException));
            return null;
        }
        catch (IOException iOException) {
            System.err.println("Weird... Cannot parse basic file:\n" + String.valueOf(iOException));
            return null;
        }
        return document;
    }

    public static Document createDocument() {
        DocumentBuilder documentBuilder;
        Document document = XConfiguration.getDefaultDocument();
        if (document == null) {
            return null;
        }
        Element element = document.getDocumentElement();
        DocumentBuilderFactory documentBuilderFactory = ScilabDocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Cannot create a XML DocumentBuilder:\n" + String.valueOf(parserConfigurationException));
            return null;
        }
        List<File> list = XConfiguration.getEtcDir();
        for (File file : list) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".xml") && string.startsWith("XConfiguration-");
                }
            })) {
                try {
                    NodeList nodeList;
                    Object object;
                    Document document2 = documentBuilder.parse(file2);
                    if (file2.getName().equals("XConfiguration-general.xml")) {
                        try {
                            object = xpathFactory.newXPath();
                            nodeList = (NodeList)object.compile("//shortcuts/body/actions/action-folder/action[contains(@key, 'OSSCKEY')]").evaluate(document2, XPathConstants.NODESET);
                            for (int i = 0; i < nodeList.getLength(); ++i) {
                                Element element2 = (Element)nodeList.item(i);
                                element2.setAttribute("key", element2.getAttribute("key").replace("OSSCKEY", ScilabKeyStroke.getOSMetaKey()));
                            }
                        }
                        catch (XPathExpressionException xPathExpressionException) {
                            System.err.println(xPathExpressionException);
                        }
                    }
                    if ((nodeList = element.getElementsByTagName((object = document.importNode(document2.getDocumentElement(), true)).getNodeName())).getLength() == 0) continue;
                    element.replaceChild((Node)object, nodeList.item(0));
                }
                catch (SAXException sAXException) {
                    System.err.println(ERROR_READ + file2.getName());
                }
                catch (IOException iOException) {
                    System.err.println(ERROR_READ + file2.getName());
                }
            }
        }
        return document;
    }

    public static List<File> getEtcDir() {
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(SCI + "/modules/");
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            File file3 = new File(file2, "/etc/");
            if (!file3.exists() || !file3.isDirectory()) continue;
            arrayList.add(file3);
        }
        return arrayList;
    }

    public static void addModifiedPath(String string) {
        if (string != null && !string.isEmpty()) {
            modifiedPaths.add(string);
        }
    }

    public static void invalidate() {
        modifiedPaths.clear();
        doc = null;
    }

    public static void addXConfigurationListener(XConfigurationListener xConfigurationListener) {
        listenerList.add(XConfigurationListener.class, xConfigurationListener);
    }

    public static void removeXConfigurationListener(XConfigurationListener xConfigurationListener) {
        listenerList.remove(XConfigurationListener.class, xConfigurationListener);
    }

    public static XConfigurationListener[] getXConfigurationListeners() {
        return (XConfigurationListener[])listenerList.getListeners(XConfigurationListener.class);
    }

    public static void fireXConfigurationEvent() {
        if (!modifiedPaths.isEmpty()) {
            XConfigurationEvent xConfigurationEvent = null;
            Object[] objectArray = listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != XConfigurationListener.class) continue;
                if (xConfigurationEvent == null) {
                    xConfigurationEvent = new XConfigurationEvent(modifiedPaths);
                }
                ((XConfigurationListener)objectArray[i + 1]).configurationChanged(xConfigurationEvent);
            }
            modifiedPaths.clear();
        }
    }

    public static void registerStringParser(Class<?> clazz, StringParser stringParser) {
        conv.put(clazz, stringParser);
    }

    public static StringParser getStringParser(Class<?> clazz) {
        return conv.get(clazz);
    }

    public static void set(Document document, String string, String string2) {
        NodeList nodeList;
        XPath xPath = xpathFactory.newXPath();
        try {
            nodeList = (NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            System.err.println(xPathExpressionException);
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null || node.getNodeType() != 2) continue;
            node.setNodeValue(string2);
        }
        XConfiguration.writeDocument(USER_CONFIG_FILE, document);
    }

    public static void save() {
        if (doc != null) {
            XConfiguration.writeDocument(USER_CONFIG_FILE, doc);
        }
    }

    public static final <T> T[] get(Class<T> clazz, Document document, String string) {
        Method[] methodArray;
        NodeList nodeList;
        XPath xPath = xpathFactory.newXPath();
        try {
            nodeList = (NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            System.err.println(xPathExpressionException);
            return (Object[])Array.newInstance(clazz, 0);
        }
        if (clazz.getAnnotation(XConfAttribute.class) != null && (methodArray = XConfiguration.get(clazz, nodeList)) != null) {
            return methodArray;
        }
        methodArray = clazz.getDeclaredMethods();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (Method object : methodArray) {
            String instantiationException = object.getName();
            if (!instantiationException.startsWith("set") || object.getParameterTypes().length != 1 || !object.getReturnType().equals(Void.TYPE)) continue;
            hashMap.put(object.getName(), object);
            object.setAccessible(true);
        }
        HashMap hashMap2 = new HashMap();
        Object[] objectArray = (Object[])Array.newInstance(clazz, nodeList.getLength());
        for (int i = 0; i < objectArray.length; ++i) {
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            try {
                Constructor<T> illegalAccessException = clazz.getDeclaredConstructor(new Class[0]);
                illegalAccessException.setAccessible(true);
                objectArray[i] = illegalAccessException.newInstance(new Object[0]);
            }
            catch (InstantiationException noSuchMethodException) {
                System.err.println(noSuchMethodException);
                break;
            }
            catch (IllegalAccessException invocationTargetException) {
                System.err.println(invocationTargetException);
                break;
            }
            catch (NoSuchMethodException j) {
                System.err.println(j);
                break;
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println(invocationTargetException.getTargetException());
            }
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                StringParser stringParser;
                Object[] objectArray2;
                String[] stringArray;
                CharSequence charSequence;
                Node node = namedNodeMap.item(j);
                String string2 = node.getNodeName();
                String string3 = (String)hashMap2.get(string2);
                if (string3 == null) {
                    charSequence = new StringBuilder("set");
                    stringArray = string2.split("-");
                    objectArray2 = stringArray;
                    int n = objectArray2.length;
                    for (int k = 0; k < n; ++k) {
                        Object illegalArgumentException = objectArray2[k];
                        if (illegalArgumentException == null || ((String)illegalArgumentException).length() <= 0) continue;
                        ((StringBuilder)charSequence).append(((String)illegalArgumentException).substring(0, 1).toUpperCase());
                        ((StringBuilder)charSequence).append(((String)illegalArgumentException).substring(1).toLowerCase());
                    }
                    string3 = ((StringBuilder)charSequence).toString();
                    hashMap2.put(string2, string3);
                }
                charSequence = node.getNodeValue();
                stringArray = (String[])hashMap.get(string3);
                if (stringArray == null || (stringParser = conv.get((objectArray2 = stringArray.getParameterTypes())[0])) == null) continue;
                Object[] objectArray3 = new Object[]{stringParser.parse((String)charSequence)};
                try {
                    stringArray.invoke(objectArray[i], objectArray3);
                    continue;
                }
                catch (IllegalAccessException invocationTargetException) {
                    System.err.println(invocationTargetException);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(illegalArgumentException);
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println(invocationTargetException.getTargetException());
                }
            }
        }
        return objectArray;
    }

    public static final <T, U> Map<T, U> get(Document document, String string, Class<T> clazz, String string2, Class<U> clazz2, String string3) {
        NodeList nodeList;
        XPath xPath = xpathFactory.newXPath();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        try {
            nodeList = (NodeList)xPath.compile(string3).evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            System.err.println(xPathExpressionException);
            return hashMap;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            Node node = namedNodeMap.getNamedItem(string);
            Node node2 = namedNodeMap.getNamedItem(string2);
            if (node == null || node2 == null) {
                return hashMap;
            }
            String string4 = node.getNodeValue();
            String string5 = node2.getNodeValue();
            StringParser stringParser = conv.get(clazz);
            StringParser stringParser2 = conv.get(clazz2);
            if (stringParser == null || stringParser2 == null) {
                return hashMap;
            }
            hashMap.put(stringParser.parse(string4), stringParser2.parse(string5));
        }
        return hashMap;
    }

    private static final <T> T[] get(Class<T> clazz, NodeList nodeList) {
        Object object;
        Object object2;
        Method[] methodArray = clazz.getDeclaredMethods();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<Method> arrayList2 = new ArrayList<Method>();
        for (Method method : methodArray) {
            String string = method.getName();
            object2 = method.getAnnotation(XConfAttribute.class);
            if (object2 == null) continue;
            object = object2.attributes();
            if (((String[])object).length == method.getParameterTypes().length) {
                method.setAccessible(true);
                arrayList.add((String[])object);
                arrayList2.add(method);
                continue;
            }
            return null;
        }
        XConfAttribute xConfAttribute = clazz.getAnnotation(XConfAttribute.class);
        int n = !xConfAttribute.isStatic() ? 1 : 0;
        Object[] objectArray = null;
        int n2 = nodeList.getLength();
        if (n != 0) {
            objectArray = (Object[])Array.newInstance(clazz, n2);
        }
        for (int i = 0; i < n2; ++i) {
            object2 = nodeList.item(i).getAttributes();
            object = nodeList.item(i).getNodeName();
            if (n != 0) {
                try {
                    Constructor<T> noSuchMethodException = clazz.getDeclaredConstructor(new Class[0]);
                    noSuchMethodException.setAccessible(true);
                    objectArray[i] = noSuchMethodException.newInstance(new Object[0]);
                }
                catch (InstantiationException invocationTargetException) {
                    System.err.println(invocationTargetException);
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println(illegalAccessException);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.err.println(noSuchMethodException);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println(invocationTargetException.getTargetException());
                }
            }
            for (int illegalAccessException = 0; illegalAccessException < arrayList2.size(); ++illegalAccessException) {
                Method method = (Method)arrayList2.get(illegalAccessException);
                XConfAttribute xConfAttribute2 = method.getAnnotation(XConfAttribute.class);
                String string = xConfAttribute2.tag();
                if (!string.isEmpty() && !string.equals(object)) continue;
                String[] stringArray = (String[])arrayList.get(illegalAccessException);
                Object[] objectArray2 = new Object[stringArray.length];
                Class<?>[] classArray = method.getParameterTypes();
                for (int invocationTargetException = 0; invocationTargetException < stringArray.length; ++invocationTargetException) {
                    StringParser stringParser;
                    String string2 = "";
                    Node node = null;
                    if (object2 != null) {
                        node = object2.getNamedItem(stringArray[invocationTargetException]);
                    }
                    if (node != null) {
                        string2 = node.getNodeValue();
                    }
                    if ((stringParser = conv.get(classArray[invocationTargetException])) == null) continue;
                    objectArray2[invocationTargetException] = stringParser.parse(string2);
                }
                try {
                    if (n != 0) {
                        method.invoke(objectArray[i], objectArray2);
                        continue;
                    }
                    method.invoke(null, objectArray2);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException2) {
                    System.err.println(illegalAccessException2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(illegalArgumentException);
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println(invocationTargetException.getTargetException());
                }
            }
        }
        if (n != 0) {
            return objectArray;
        }
        return (Object[])Array.newInstance(clazz, 0);
    }

    static {
        mustSave = true;
        USER_CONFIG_FILE = ScilabConstants.SCIHOME.toString() + "/XConfiguration.xml";
        if (ScilabConstants.SCIHOME != null && ScilabConstants.SCIHOME.canRead() && ScilabConstants.SCIHOME.canWrite()) {
            USER_CONFIG_FILE = ScilabConstants.SCIHOME.toString() + "/XConfiguration.xml";
        } else {
            USER_CONFIG_FILE = SCILAB_CONFIG_FILE;
            mustSave = false;
        }
        XConfiguration.addXConfigurationListener(ScilabGeneralPrefs.getInstance());
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("org.scilab.modules.history_manager.HistoryPrefs");
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            XConfiguration.addXConfigurationListener((XConfigurationListener)method.invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        conv.put(Integer.TYPE, new StringParser(){

            @Override
            public Integer parse(String string) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return (int)Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return new Integer(0);
                    }
                }
            }
        });
        conv.put(Character.TYPE, new StringParser(){

            @Override
            public Object parse(String string) {
                if (string.length() > 0) {
                    return Character.valueOf(string.charAt(0));
                }
                return new Character('\u0000');
            }
        });
        conv.put(Byte.TYPE, new StringParser(){

            @Override
            public Object parse(String string) {
                try {
                    return Byte.parseByte(string);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return (byte)Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return new Byte(0);
                    }
                }
            }
        });
        conv.put(Short.TYPE, new StringParser(){

            @Override
            public Object parse(String string) {
                try {
                    return Short.parseShort(string);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return (short)Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return new Short(0);
                    }
                }
            }
        });
        conv.put(Double.TYPE, new StringParser(){

            @Override
            public Object parse(String string) {
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return new Double(0.0);
                }
            }
        });
        conv.put(Float.TYPE, new StringParser(){

            @Override
            public Object parse(String string) {
                try {
                    return Float.valueOf(Float.parseFloat(string));
                }
                catch (NumberFormatException numberFormatException) {
                    return new Float(0.0f);
                }
            }
        });
        conv.put(Boolean.TYPE, new StringParser(){

            @Override
            public Object parse(String string) {
                return Boolean.parseBoolean(string);
            }
        });
        conv.put(Long.TYPE, new StringParser(){

            @Override
            public Object parse(String string) {
                try {
                    return Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return (long)Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return new Long(0L);
                    }
                }
            }
        });
        conv.put(String.class, new StringParser(){

            @Override
            public Object parse(String string) {
                return string;
            }
        });
        conv.put(Color.class, new StringParser(){

            @Override
            public Object parse(String string) {
                try {
                    return Color.decode(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return Color.BLACK;
                }
            }
        });
        conv.put(KeyStroke.class, new StringParser(){

            @Override
            public Object parse(String string) {
                String[] stringArray = string.split(" +");
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    stringBuilder.append(stringArray[i].toLowerCase());
                    stringBuilder.append(" ");
                }
                stringBuilder.append(stringArray[stringArray.length - 1].toUpperCase());
                return KeyStroke.getKeyStroke(stringBuilder.toString());
            }
        });
    }

    public static interface StringParser {
        public Object parse(String var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface XConfAttribute {
        public String[] attributes() default {""};

        public String tag() default "";

        public boolean isStatic() default false;
    }
}

