/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.console;

import com.artenum.rosetta.interfaces.ui.OutputView;
import com.artenum.rosetta.util.BufferedWriter;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.PlainView;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.scilab.modules.commons.gui.ScilabCaret;
import org.scilab.modules.console.SciConsole;
import org.scilab.modules.console.SciDropTargetListener;
import org.scilab.modules.console.SciInputCommandView;

public class SciOutputView
extends JEditorPane
implements OutputView,
ViewFactory {
    private static final long serialVersionUID = 1L;
    private static final int TOP_BORDER = 0;
    private static final int BOTTOM_BORDER = 0;
    private static final int LEFT_BORDER = 0;
    private static final int RIGHT_BORDER = 0;
    private static final int BUFFER_SIZE = 10;
    private String activeStyle;
    private String lastAppendedStyle;
    private BlockingQueue<StringBuffer> bufferQueue;
    private LinkedList<String> styleQueue;
    private StringBuffer currentWorkingBuffer;
    private SciConsole console;
    private Thread thread;
    private int insertPosition;
    private int maxNumberOfLines;
    private boolean lastEOL;

    public SciOutputView() {
        this.setEditorKit(new DefaultEditorKit(){

            @Override
            public ViewFactory getViewFactory() {
                return SciOutputView.this;
            }
        });
        this.setDocument(new PlainDocument());
        this.setMaxSize(10000);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setDragEnabled(true);
        this.setDoubleBuffered(true);
        this.activeStyle = "default";
        this.bufferQueue = new ArrayBlockingQueue<StringBuffer>(10);
        this.styleQueue = new LinkedList();
        final class FixedCaret
        extends ScilabCaret {
            private static final long serialVersionUID = 8230195712653828841L;

            private FixedCaret() {
                super((JTextComponent)SciOutputView.this);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isMiddleMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    Transferable transferable;
                    Toolkit toolkit;
                    Clipboard clipboard;
                    JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
                    if (jTextComponent != null && (clipboard = (toolkit = jTextComponent.getToolkit()).getSystemSelection()) != null && (transferable = clipboard.getContents(null)).isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        try {
                            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            ((JTextPane)SciOutputView.this.getConsole().getConfiguration().getInputCommandView()).replaceSelection(string);
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            unsupportedFlavorException.printStackTrace();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    ((JTextPane)SciOutputView.this.getConsole().getConfiguration().getInputCommandView()).requestFocus();
                    ((JTextPane)SciOutputView.this.getConsole().getConfiguration().getInputCommandView()).getCaret().setVisible(true);
                } else {
                    super.mouseClicked(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ((SciInputCommandView)SciOutputView.this.console.getConfiguration().getInputCommandView()).removeSelection();
                super.mousePressed(mouseEvent);
            }
        }
        this.setCaret((Caret)((Object)new FixedCaret()));
        this.getCaret().setSelectionVisible(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ((JTextPane)SciOutputView.this.getConsole().getConfiguration().getInputCommandView()).requestFocus();
            }
        });
    }

    public void removeSelection() {
        if (this.getSelectionStart() != this.getSelectionEnd()) {
            this.setSelectionEnd(this.getSelectionStart());
        }
    }

    public void setStyledDocument(StyledDocument styledDocument) {
    }

    public void resetLastEOL() {
        this.lastEOL = false;
    }

    private void displayLineBuffer(String object, String string) {
        Object object2;
        boolean bl;
        int n;
        block21: {
            String[] stringArray;
            n = this.getDocument().getLength();
            bl = false;
            object = ((String)object).replaceAll("\r\n", "\n");
            bl = ((String)object).endsWith("\r");
            if (((String)object).startsWith("\r") & !this.lastEOL) {
                try {
                    stringArray = this.getDocument().getText(0, this.getDocument().getLength());
                    this.insertPosition = stringArray.lastIndexOf("\n") + 1;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            if (((String)object).contains("\r") & ((String)object).length() > 1) {
                stringArray = ((String)object).split("\r");
                object = stringArray[0];
                for (int i = 1; i < stringArray.length; ++i) {
                    object = stringArray[i] + (((String)object).length() >= stringArray[i].length() ? ((String)object).substring(stringArray[i].length()) : "");
                }
            }
            boolean bl2 = this.lastEOL;
            this.lastEOL = !((String)object).isEmpty() && ((String)object).charAt(((String)object).length() - 1) == '\n';
            object2 = object;
            if (this.lastEOL) {
                object2 = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (bl2) {
                object2 = "\n" + (String)object2;
            }
            if (this.insertPosition != 0 && this.insertPosition < n) {
                n = this.insertPosition;
                try {
                    if (((String)object2).equals("\n")) break block21;
                    if (this.insertPosition + ((String)object2).length() <= this.getDocument().getLength()) {
                        this.getDocument().remove(this.insertPosition, ((String)object2).length());
                        break block21;
                    }
                    this.getDocument().remove(this.insertPosition, this.getDocument().getLength() - this.insertPosition);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            } else {
                this.insertPosition = 0;
            }
        }
        try {
            this.getDocument().insertString(n, (String)object2, null);
            if (this.insertPosition != 0) {
                this.insertPosition += ((String)object2).length();
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        int n2 = this.getDocument().getDefaultRootElement().getElementCount();
        if ((double)n2 > 1.5 * (double)this.maxNumberOfLines) {
            try {
                this.getDocument().remove(0, this.getDocument().getDefaultRootElement().getElement(n2 - this.maxNumberOfLines - 1).getEndOffset());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        if (bl) {
            try {
                String string2 = this.getDocument().getText(0, this.getDocument().getLength());
                this.insertPosition = string2.lastIndexOf("\n") + 1;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void append(String string) {
        this.displayLineBuffer(string, this.activeStyle);
    }

    public void append(String string, String string2) {
        if (string2.equals(this.lastAppendedStyle) && this.bufferQueue.size() > 1) {
            this.currentWorkingBuffer.append(string);
        } else {
            this.lastAppendedStyle = string2;
            this.styleQueue.add(this.lastAppendedStyle);
            try {
                this.currentWorkingBuffer = new StringBuffer(string);
                this.bufferQueue.put(this.currentWorkingBuffer);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (!this.thread.isAlive()) {
            this.thread.run();
        }
    }

    public Writer getErrorWriter() {
        return new BufferedWriter("default", this.bufferQueue, this.styleQueue);
    }

    public Writer getWriter() {
        return new BufferedWriter("default", this.bufferQueue, this.styleQueue);
    }

    public void reset() {
        this.setText("");
        this.setCaretPosition(0);
        this.lastEOL = false;
    }

    public void setCaretPositionToBeginning() {
        this.insertPosition = 0;
        this.setCaretPosition(0);
    }

    public void setCaretPositionToEnd() {
        this.insertPosition = 0;
        this.setCaretPosition(this.getDocument().getLength());
    }

    public void setStyleName(String string) {
        this.activeStyle = string;
    }

    public void setConsole(SciConsole sciConsole) {
        this.console = sciConsole;
        this.setDropTarget(new DropTarget(this, 3, new SciDropTargetListener(this.console)));
    }

    public SciConsole getConsole() {
        return this.console;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setMaxSize(int n) {
        this.maxNumberOfLines = Math.max(1, n);
    }

    @Override
    public View create(Element element) {
        return new PlainView(element){

            @Override
            public Container getContainer() {
                return SciOutputView.this;
            }
        };
    }
}

