/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BlockManager;
import com.sun.java.help.search.BlockProcessor;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.Schema;
import java.io.UnsupportedEncodingException;

public class BtreeDict {
    protected static final int ENTHEADERLEN = 6;
    protected static final int BLOCKSIZE = 2048;
    protected static final int DATALEN = 2040;
    protected static final int MaxKeyLength = 255;
    protected static final int lastPtrIndex = 508;
    protected BlockManager blockManager;
    protected int root;
    protected int[] blocks;
    private boolean debug = false;

    protected BtreeDict() {
    }

    public BtreeDict(BtreeDictParameters params) throws Exception {
        this.init(params, false, new BlockFactory(){

            public Block makeBlock() {
                return new DictBlock();
            }
        });
        this.blocks = new int[params.getFreeID()];
        this.setBlocks(this.blocks);
    }

    public int fetch(String key) throws Exception {
        byte[] bytes = key.getBytes("UTF8");
        byte[] Key2 = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, Key2, 0, bytes.length);
        Key2[bytes.length] = 0;
        return this.find(this.accessBlock(this.root), Key2);
    }

    public String fetch(int conceptID) throws Exception {
        return this.findID(this.blocks[conceptID], conceptID);
    }

    public void close() throws Exception {
        this.blockManager.close();
    }

    protected void init(BtreeDictParameters params, boolean update, BlockFactory bfactory) throws Exception {
        this.blockManager = new BlockManager(params, update, bfactory);
        this.root = params.getRootPosition();
    }

    protected void lock(Block bl) {
        this.blockManager.lockBlock(bl.number);
    }

    protected void unlock(Block bl) {
        this.blockManager.unlockBlock(bl.number);
    }

    protected DictBlock accessBlock(int index) throws Exception {
        return (DictBlock)this.blockManager.accessBlock(index);
    }

    protected DictBlock child(DictBlock bl, int index) throws Exception {
        return this.accessBlock(bl.getChildIdx(index));
    }

    private String findID(int blNum, int id) throws Exception {
        return this.accessBlock(blNum).findID(id);
    }

    private int find(DictBlock bl, byte[] key, int index) throws Exception {
        return bl.isLeaf ? 0 : this.find(this.child(bl, index), key);
    }

    private int find(DictBlock bl, byte[] key) throws Exception {
        int inputKeyLen = key.length - 1;
        int entryPtr = bl.firstEntry();
        int freeSpace = bl.free();
        int nCharsEqual = 0;
        int compression = 0;
        int entryIdx = 0;
        while (entryPtr != freeSpace) {
            if (compression == nCharsEqual) {
                int i;
                int keyLen = bl.entryKeyLength(entryPtr);
                int keyPtr = bl.entryKey(entryPtr);
                for (i = 0; i < keyLen && key[nCharsEqual] == bl.data[keyPtr + i]; ++i) {
                    ++nCharsEqual;
                }
                if (i == keyLen) {
                    if (nCharsEqual == inputKeyLen) {
                        return bl.entryID(entryPtr);
                    }
                } else if ((key[nCharsEqual] & 0xFF) < (bl.data[keyPtr + i] & 0xFF)) {
                    return this.find(bl, key, entryIdx);
                }
            } else if (compression < nCharsEqual) {
                return this.find(bl, key, entryPtr == freeSpace ? bl.numberOfEntries() : entryIdx);
            }
            do {
                entryPtr = bl.nextEntry(entryPtr);
                ++entryIdx;
            } while (bl.entryCompression(entryPtr) > nCharsEqual);
            compression = bl.entryCompression(entryPtr);
        }
        return this.find(bl, key, bl.numberOfEntries());
    }

    private void setBlocks(final int[] blocks) throws Exception {
        long start = System.currentTimeMillis();
        this.blockManager.mapBlocks(new BlockProcessor(){

            public void process(Block block) {
                ((DictBlock)block).setBlockNumbers(blocks);
            }
        });
        this.debug(System.currentTimeMillis() - start + " msec; TMAP");
    }

    private void debug(String msg) {
        if (this.debug) {
            System.err.println("BtreeDict: " + msg);
        }
    }

    public static void main(String[] args) {
        try {
            Schema schema = new Schema(null, args[0], false);
            BtreeDictParameters params = new BtreeDictParameters(schema, "TMAP");
            BtreeDict btreeDict = new BtreeDict(params);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    protected class DictBlock
    extends Block {
        public DictBlock() {
            super(2048);
        }

        public int free() {
            return this.free + this.firstEntry();
        }

        public int numberOfEntries() {
            return this.integerAt(0);
        }

        public int nthPointer(int n) {
            return this.integerAt(4 * (n + 1));
        }

        public int getChildIdx(int index) {
            return this.nthPointer(508 - index);
        }

        public int entryKeyLength(int i) {
            return this.data[i] & 0xFF;
        }

        public int entryCompression(int i) {
            return this.data[i + 1] & 0xFF;
        }

        public int entryID(int i) {
            return this.integerAt(i + 2);
        }

        public int entryLength(int entry) {
            return 6 + this.entryKeyLength(entry);
        }

        public int entryKey(int entry) {
            return entry + 6;
        }

        public int firstEntry() {
            return 4;
        }

        public int nextEntry(int entry) {
            return entry + this.entryLength(entry);
        }

        public void restoreKeyInBuffer(int entry, byte[] buffer) {
            int howMany = this.entryKeyLength(entry);
            int where = this.entryCompression(entry);
            int from = this.entryKey(entry);
            while (howMany-- > 0) {
                buffer[where++] = this.data[from++];
            }
        }

        public String restoreKey(int entry, byte[] buffer) {
            int howMany = this.entryKeyLength(entry);
            int where = this.entryCompression(entry);
            int from = this.entryKey(entry);
            while (howMany-- > 0) {
                buffer[where++] = this.data[from++];
            }
            String string = null;
            try {
                string = new String(buffer, 0, where, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            return string;
        }

        public String findID(int id) throws Exception {
            byte[] buffer = new byte[255];
            int freeSpace = this.free();
            int ent = this.firstEntry();
            while (ent < freeSpace) {
                if (this.entryID(ent) == id) {
                    return this.restoreKey(ent, buffer);
                }
                this.restoreKeyInBuffer(ent, buffer);
                ent = this.nextEntry(ent);
            }
            throw new Exception("ID not found in block");
        }

        protected void setBlockNumbers(int[] blocks) {
            int e = this.firstEntry();
            while (e < this.free) {
                blocks[this.entryID((int)e)] = this.number;
                e = this.nextEntry(e);
            }
        }
    }
}

