/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.analysis;

import com.mxgraph.analysis.StructuralException;
import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.analysis.mxGraphProperties;
import com.mxgraph.analysis.mxTraversal;
import com.mxgraph.costfunction.mxCostFunction;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class mxGraphStructure {
    private static String basicVertexStyleString = "ellipse;strokeColor=black;fillColor=orange;gradientColor=none";
    private static String basicEdgeStyleString = "strokeColor=red;noEdgeStyle=1;";
    private static String basicArrowStyleString = "endArrow=block;";

    public static boolean isConnected(mxAnalysisGraph mxAnalysisGraph2) {
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxAnalysisGraph2.getGraph().getDefaultParent());
        int n = objectArray.length;
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        int n2 = 1;
        int[] nArray = new int[n];
        nArray[0] = 1;
        for (int i = 1; i < n; ++i) {
            nArray[i] = 0;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(objectArray[0]);
        while (arrayList.size() > 0) {
            Object e = arrayList.get(0);
            arrayList.remove(0);
            Object[] objectArray2 = mxAnalysisGraph2.getOpposites(mxAnalysisGraph2.getEdges(e, null, true, true, false, true), e, true, true);
            for (int i = 0; i < objectArray2.length; ++i) {
                int n3 = 0;
                for (int j = 0; j < n; ++j) {
                    if (!objectArray[j].equals(objectArray2[i])) continue;
                    n3 = j;
                }
                if (nArray[n3] != 0) continue;
                arrayList.add(objectArray[n3]);
                nArray[n3] = 1;
                ++n2;
            }
        }
        return n2 == n;
    }

    public static boolean isCyclicUndirected(mxAnalysisGraph mxAnalysisGraph2) {
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        Object[] objectArray = mxIGraphModel2.cloneCells(mxAnalysisGraph2.getChildCells(mxGraph2.getDefaultParent(), true, true), true);
        mxGraphModel mxGraphModel2 = new mxGraphModel();
        mxGraph mxGraph3 = new mxGraph(mxGraphModel2);
        Object object = mxGraph3.getDefaultParent();
        mxGraph3.addCells(objectArray);
        mxAnalysisGraph mxAnalysisGraph3 = new mxAnalysisGraph();
        mxAnalysisGraph3.setGraph(mxGraph3);
        mxAnalysisGraph3.setGenerator(mxAnalysisGraph2.getGenerator());
        mxAnalysisGraph3.setProperties(mxAnalysisGraph2.getProperties());
        Object[] objectArray2 = new Object[]{mxGraphStructure.getUndirectedLeaf(mxAnalysisGraph3)};
        do {
            if (objectArray2[0] == null) continue;
            mxGraph3.removeCells(objectArray2);
        } while (objectArray2[0] != null);
        int n = mxAnalysisGraph3.getChildVertices(object).length;
        return n > 0;
    }

    private static Object getUndirectedLeaf(mxAnalysisGraph mxAnalysisGraph2) {
        Object object = mxAnalysisGraph2.getGraph().getDefaultParent();
        for (Object object2 : mxAnalysisGraph2.getChildVertices(object)) {
            int n = mxAnalysisGraph2.getEdges(object2, object, true, true, false, true).length;
            if (n > 1) continue;
            return object2;
        }
        return null;
    }

    public static boolean isSimple(mxAnalysisGraph mxAnalysisGraph2) {
        Object object = mxAnalysisGraph2.getGraph().getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildEdges(object);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (mxAnalysisGraph2.getTerminal(object2, true) == mxAnalysisGraph2.getTerminal(object2, false)) {
                return false;
            }
            for (int j = 0; j < objectArray.length; ++j) {
                Object object3 = objectArray[j];
                if (object2 == object3) continue;
                if (mxAnalysisGraph2.getTerminal(object2, true) == mxAnalysisGraph2.getTerminal(object3, true) && mxAnalysisGraph2.getTerminal(object2, false) == mxAnalysisGraph2.getTerminal(object3, false)) {
                    return false;
                }
                if (mxAnalysisGraph2.getTerminal(object2, true) != mxAnalysisGraph2.getTerminal(object3, false) || mxAnalysisGraph2.getTerminal(object2, false) != mxAnalysisGraph2.getTerminal(object3, true)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isTree(mxAnalysisGraph mxAnalysisGraph2) {
        return mxGraphStructure.isConnected(mxAnalysisGraph2) && !mxGraphStructure.isCyclicUndirected(mxAnalysisGraph2) && mxGraphStructure.isSimple(mxAnalysisGraph2);
    }

    public static Object getLowestDegreeVertex(mxAnalysisGraph mxAnalysisGraph2, Object[] objectArray) {
        Object[] objectArray2 = mxAnalysisGraph2.getChildVertices(mxAnalysisGraph2.getGraph().getDefaultParent());
        int n = objectArray2.length;
        int n2 = Integer.MAX_VALUE;
        Object object = null;
        List<Object> list = null;
        if (objectArray != null) {
            list = Arrays.asList(objectArray);
        }
        for (int i = 0; i < n; ++i) {
            if (objectArray != null && list.contains(objectArray2[i])) continue;
            int n3 = mxAnalysisGraph2.getEdges(objectArray2[i], null, true, true, true, true).length;
            if (n3 == 0) {
                return objectArray2[i];
            }
            if (n3 >= n2) continue;
            n2 = n3;
            object = objectArray2[i];
        }
        return object;
    }

    public static boolean areConnected(mxAnalysisGraph mxAnalysisGraph2, Object object, Object object2) {
        Object[] objectArray = mxAnalysisGraph2.getEdges(object, mxAnalysisGraph2.getGraph().getDefaultParent(), true, true, false, true);
        List<Object> list = Arrays.asList(mxAnalysisGraph2.getOpposites(objectArray, object, true, true));
        return list.contains(object2);
    }

    public static void makeSimple(mxAnalysisGraph mxAnalysisGraph2) {
        ArrayList<Object> arrayList;
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildEdges(object);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList = objectArray[i];
            if (mxAnalysisGraph2.getTerminal(arrayList, true) != mxAnalysisGraph2.getTerminal(arrayList, false)) continue;
            mxGraph2.removeCells(new Object[]{arrayList});
        }
        objectArray = mxGraph2.getChildEdges(object);
        HashSet hashSet = new HashSet();
        arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            Object object3 = mxAnalysisGraph2.getTerminal(object2, true);
            Object object4 = mxAnalysisGraph2.getTerminal(object2, false);
            HashSet<Object> hashSet2 = new HashSet<Object>();
            hashSet2.add(object3);
            hashSet2.add(object4);
            if (hashSet.contains(hashSet2)) {
                arrayList.add(object2);
                continue;
            }
            hashSet.add(hashSet2);
        }
        Object[] objectArray2 = arrayList.toArray();
        mxGraph2.removeCells(objectArray2);
    }

    public static void makeConnected(mxAnalysisGraph mxAnalysisGraph2) {
        if (mxGraphStructure.isConnected(mxAnalysisGraph2)) {
            return;
        }
        Object[][] objectArray = mxGraphStructure.getGraphComponents(mxAnalysisGraph2);
        int n = objectArray.length;
        if (n < 2) {
            return;
        }
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        for (int i = 1; i < n; ++i) {
            Object object2 = objectArray[i - 1][(int)Math.round(Math.random() * (double)(objectArray[i - 1].length - 1))];
            Object object3 = objectArray[i][(int)Math.round(Math.random() * (double)(objectArray[i].length - 1))];
            mxGraph2.insertEdge(object, null, mxAnalysisGraph2.getGenerator().getNewEdgeValue(mxAnalysisGraph2), object2, object3);
        }
    }

    public static Object[][] getGraphComponents(mxAnalysisGraph mxAnalysisGraph2) {
        int n;
        Object[][] objectArrayArray;
        Object object = mxAnalysisGraph2.getGraph().getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object);
        int n2 = objectArray.length;
        if (n2 == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>(Arrays.asList(objectArray));
        boolean bl = mxGraphProperties.isDirected(mxAnalysisGraph2.getProperties(), mxGraphProperties.DEFAULT_DIRECTED);
        mxGraphProperties.setDirected(mxAnalysisGraph2.getProperties(), false);
        while (arrayList2.size() > 0) {
            objectArrayArray = arrayList2.remove(0);
            n = arrayList.size();
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                if (!((ArrayList)arrayList.get(i)).contains(objectArrayArray)) continue;
                bl2 = true;
            }
            if (bl2) continue;
            final ArrayList arrayList3 = new ArrayList();
            mxTraversal.bfs(mxAnalysisGraph2, objectArrayArray, new mxGraph.mxICellVisitor(){

                @Override
                public boolean visit(Object object, Object object2) {
                    arrayList3.add(object);
                    return false;
                }
            });
            for (int i = 0; i < arrayList3.size(); ++i) {
                arrayList2.remove(arrayList3.get(i));
            }
            arrayList.add(arrayList3);
        }
        mxGraphProperties.setDirected(mxAnalysisGraph2.getProperties(), bl);
        objectArrayArray = new Object[arrayList.size()][];
        for (n = 0; n < arrayList.size(); ++n) {
            objectArrayArray[n] = ((ArrayList)arrayList.get(n)).toArray();
        }
        return objectArrayArray;
    }

    public static void makeTreeDirected(mxAnalysisGraph mxAnalysisGraph2, Object object) throws StructuralException {
        if (mxGraphStructure.isTree(mxAnalysisGraph2)) {
            mxGraphProperties.setDirected(mxAnalysisGraph2.getProperties(), false);
            final ArrayList arrayList = new ArrayList();
            mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
            mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
            Object object2 = mxGraph2.getDefaultParent();
            mxTraversal.bfs(mxAnalysisGraph2, object, new mxGraph.mxICellVisitor(){

                @Override
                public boolean visit(Object object, Object object2) {
                    arrayList.add(object);
                    return false;
                }
            });
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                Object[] objectArray = mxAnalysisGraph2.getEdges(e, object2, true, true, false, true);
                Object[] objectArray2 = mxAnalysisGraph2.getOpposites(objectArray, e, true, true);
                for (int j = 0; j < objectArray2.length; ++j) {
                    Object object3 = objectArray2[j];
                    int n = arrayList.indexOf(object3);
                    if (n <= i) continue;
                    Object object4 = mxGraphStructure.getConnectingEdge(mxAnalysisGraph2, e, object3);
                    mxIGraphModel2.setTerminal(object4, e, true);
                    mxIGraphModel2.setTerminal(object4, object3, false);
                }
            }
        } else {
            throw new StructuralException("The graph is not a tree");
        }
        mxGraphProperties.setDirected(mxAnalysisGraph2.getProperties(), true);
        mxGraphStructure.setDefaultGraphStyle(mxAnalysisGraph2, false);
    }

    public static Object getConnectingEdge(mxAnalysisGraph mxAnalysisGraph2, Object object, Object object2) {
        mxIGraphModel mxIGraphModel2 = mxAnalysisGraph2.getGraph().getModel();
        Object[] objectArray = mxAnalysisGraph2.getEdges(object, null, true, true, false, true);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object3 = objectArray[i];
            Object object4 = mxIGraphModel2.getTerminal(object3, true);
            Object object5 = mxIGraphModel2.getTerminal(object3, false);
            if (object4.equals(object) && object5.equals(object2)) {
                return object3;
            }
            if (!object4.equals(object2) || !object5.equals(object)) continue;
            return object3;
        }
        return null;
    }

    public static boolean isCyclicDirected(mxAnalysisGraph mxAnalysisGraph2) {
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        Object[] objectArray = mxIGraphModel2.cloneCells(mxAnalysisGraph2.getChildCells(mxGraph2.getDefaultParent(), true, true), true);
        mxGraphModel mxGraphModel2 = new mxGraphModel();
        mxGraph mxGraph3 = new mxGraph(mxGraphModel2);
        Object object = mxGraph3.getDefaultParent();
        mxGraph3.addCells(objectArray);
        mxAnalysisGraph mxAnalysisGraph3 = new mxAnalysisGraph();
        mxAnalysisGraph3.setGraph(mxGraph3);
        mxAnalysisGraph3.setGenerator(mxAnalysisGraph2.getGenerator());
        mxAnalysisGraph3.setProperties(mxAnalysisGraph2.getProperties());
        Object[] objectArray2 = new Object[]{mxGraphStructure.getDirectedLeaf(mxAnalysisGraph3, object)};
        do {
            if (objectArray2[0] == null) continue;
            mxGraph3.removeCells(objectArray2);
        } while (objectArray2[0] != null);
        int n = mxAnalysisGraph3.getChildVertices(object).length;
        return n > 0;
    }

    public static Object getDirectedLeaf(mxAnalysisGraph mxAnalysisGraph2, Object object) {
        for (Object object2 : mxAnalysisGraph2.getChildVertices(object)) {
            int n = mxAnalysisGraph2.getEdges(object2, object, true, false, false, true).length;
            int n2 = mxAnalysisGraph2.getEdges(object2, object, false, true, false, true).length;
            if (n2 != 0 && n != 0) continue;
            return object2;
        }
        return null;
    }

    public static void complementaryGraph(mxAnalysisGraph mxAnalysisGraph2) {
        mxCell mxCell2;
        ArrayList arrayList = new ArrayList();
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            mxCell mxCell3 = (mxCell)objectArray[i];
            int n2 = mxCell3.getEdgeCount();
            mxCell2 = new mxCell();
            ArrayList<mxCell> arrayList2 = new ArrayList<mxCell>();
            for (int j = 0; j < n2; ++j) {
                mxCell2 = (mxCell)mxCell3.getEdgeAt(j);
                mxCell mxCell4 = (mxCell)mxCell2.getSource();
                mxCell mxCell5 = (mxCell)mxCell2.getTarget();
                if (!mxCell4.equals(mxCell3)) {
                    arrayList2.add(j, mxCell4);
                    continue;
                }
                arrayList2.add(j, mxCell5);
            }
            arrayList.add(i, arrayList2);
        }
        Object[] objectArray2 = mxAnalysisGraph2.getChildEdges(object);
        mxGraph2.removeCells(objectArray2);
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList3 = new ArrayList();
            arrayList3 = (ArrayList)arrayList.get(i);
            mxCell2 = (mxCell)objectArray[i];
            for (int j = 0; j < n; ++j) {
                mxCell mxCell6 = (mxCell)objectArray[j];
                boolean bl = true;
                if (arrayList3.contains(mxCell6)) {
                    bl = false;
                } else if (mxCell6.equals(mxCell2)) {
                    bl = false;
                } else if (mxGraphStructure.areConnected(mxAnalysisGraph2, mxCell2, mxCell6)) {
                    bl = false;
                }
                if (!bl) continue;
                mxGraph2.insertEdge(object, null, null, mxCell2, mxCell6);
            }
        }
    }

    public static Object getVertexWithValue(mxAnalysisGraph mxAnalysisGraph2, int n) {
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxAnalysisGraph2.getGraph().getDefaultParent());
        int n2 = objectArray.length;
        int n3 = 0;
        mxCostFunction mxCostFunction2 = mxAnalysisGraph2.getGenerator().getCostFunction();
        mxGraphView mxGraphView2 = mxGraph2.getView();
        for (int i = 0; i < n2; ++i) {
            Object object = objectArray[i];
            n3 = (int)mxCostFunction2.getCost(new mxCellState(mxGraphView2, object, null));
            if (n3 != n) continue;
            return object;
        }
        return null;
    }

    public static void setDefaultGraphStyle(mxAnalysisGraph mxAnalysisGraph2, boolean bl) {
        int n;
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object object = mxGraph2.getDefaultParent();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(object);
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        for (int i = 0; i < objectArray.length; ++i) {
            mxIGraphModel2.setStyle(objectArray[i], basicVertexStyleString);
        }
        Object[] objectArray2 = mxAnalysisGraph2.getChildEdges(object);
        boolean bl2 = mxGraphProperties.isDirected(mxAnalysisGraph2.getProperties(), mxGraphProperties.DEFAULT_DIRECTED);
        String string = basicEdgeStyleString;
        string = bl2 ? string + basicArrowStyleString : string + "endArrow=none";
        for (n = 0; n < objectArray2.length; ++n) {
            mxIGraphModel2.setStyle(objectArray2[n], string);
        }
        if (bl) {
            for (n = 0; n < objectArray2.length; ++n) {
                mxIGraphModel2.setValue(objectArray2[n], null);
            }
            for (n = 0; n < objectArray2.length; ++n) {
                mxIGraphModel2.setValue(objectArray2[n], mxAnalysisGraph2.getGenerator().getNewEdgeValue(mxAnalysisGraph2));
            }
        }
    }

    public static int regularity(mxAnalysisGraph mxAnalysisGraph2) throws StructuralException {
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxGraph2.getDefaultParent());
        int n = objectArray.length;
        Object object = objectArray[0];
        int n2 = mxAnalysisGraph2.getEdges(object, null, true, true).length;
        for (int i = 1; i < n; ++i) {
            object = objectArray[i];
            if (n2 == mxAnalysisGraph2.getEdges(object, null, true, true).length) continue;
            throw new StructuralException("The graph is irregular.");
        }
        return n2;
    }

    public static int indegree(mxAnalysisGraph mxAnalysisGraph2, Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (mxGraphProperties.isDirected(mxAnalysisGraph2.getProperties(), mxGraphProperties.DEFAULT_DIRECTED)) {
            return mxAnalysisGraph2.getEdges(object, mxAnalysisGraph2.getGraph().getDefaultParent(), true, false, true, true).length;
        }
        return mxAnalysisGraph2.getEdges(object, mxAnalysisGraph2.getGraph().getDefaultParent(), true, true, true, true).length;
    }

    public static int outdegree(mxAnalysisGraph mxAnalysisGraph2, Object object) {
        if (mxGraphProperties.isDirected(mxAnalysisGraph2.getProperties(), mxGraphProperties.DEFAULT_DIRECTED)) {
            return mxAnalysisGraph2.getEdges(object, mxAnalysisGraph2.getGraph().getDefaultParent(), false, true, true, true).length;
        }
        return mxAnalysisGraph2.getEdges(object, mxAnalysisGraph2.getGraph().getDefaultParent(), true, true, true, true).length;
    }

    public static boolean isCutVertex(mxAnalysisGraph mxAnalysisGraph2, Object object) {
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        if (mxAnalysisGraph2.getEdges(object, null, true, true, false, true).length >= 2) {
            Object[] objectArray = mxIGraphModel2.cloneCells(mxAnalysisGraph2.getChildCells(mxGraph2.getDefaultParent(), true, true), true);
            mxGraphModel mxGraphModel2 = new mxGraphModel();
            mxGraph mxGraph3 = new mxGraph(mxGraphModel2);
            mxGraph3.addCells(objectArray);
            mxAnalysisGraph mxAnalysisGraph3 = new mxAnalysisGraph();
            mxAnalysisGraph3.setGraph(mxGraph3);
            mxAnalysisGraph3.setGenerator(mxAnalysisGraph2.getGenerator());
            mxAnalysisGraph3.setProperties(mxAnalysisGraph2.getProperties());
            Object object2 = mxGraphStructure.getVertexWithValue(mxAnalysisGraph3, (int)mxAnalysisGraph2.getGenerator().getCostFunction().getCost(new mxCellState(mxGraph2.getView(), object, null)));
            mxGraph3.removeCells(new Object[]{object2}, true);
            Object[][] objectArray2 = mxGraphStructure.getGraphComponents(mxAnalysisGraph2);
            Object[][] objectArray3 = mxGraphStructure.getGraphComponents(mxAnalysisGraph3);
            if (objectArray3.length > objectArray2.length) {
                return true;
            }
        }
        return false;
    }

    public static Object[] getCutVertices(mxAnalysisGraph mxAnalysisGraph2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxAnalysisGraph2.getGraph().getDefaultParent());
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!mxGraphStructure.isCutVertex(mxAnalysisGraph2, objectArray[i])) continue;
            arrayList.add(objectArray[i]);
        }
        return arrayList.toArray();
    }

    public static boolean isCutEdge(mxAnalysisGraph mxAnalysisGraph2, Object object) {
        mxGraph mxGraph2 = mxAnalysisGraph2.getGraph();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        mxCostFunction mxCostFunction2 = mxAnalysisGraph2.getGenerator().getCostFunction();
        mxGraphView mxGraphView2 = mxGraph2.getView();
        int n = (int)mxCostFunction2.getCost(new mxCellState(mxGraphView2, mxAnalysisGraph2.getTerminal(object, true), null));
        int n2 = (int)mxCostFunction2.getCost(new mxCellState(mxGraphView2, mxAnalysisGraph2.getTerminal(object, false), null));
        if (mxAnalysisGraph2.getTerminal(object, false) != null || mxAnalysisGraph2.getTerminal(object, true) != null) {
            Object[] objectArray = mxIGraphModel2.cloneCells(mxAnalysisGraph2.getChildCells(mxGraph2.getDefaultParent(), true, true), true);
            mxGraphModel mxGraphModel2 = new mxGraphModel();
            mxGraph mxGraph3 = new mxGraph(mxGraphModel2);
            mxGraph3.addCells(objectArray);
            mxAnalysisGraph mxAnalysisGraph3 = new mxAnalysisGraph();
            mxAnalysisGraph3.setGraph(mxGraph3);
            mxAnalysisGraph3.setGenerator(mxAnalysisGraph2.getGenerator());
            mxAnalysisGraph3.setProperties(mxAnalysisGraph2.getProperties());
            Object[] objectArray2 = mxAnalysisGraph3.getChildEdges(mxAnalysisGraph3.getGraph().getDefaultParent());
            Object object2 = objectArray2[0];
            mxCostFunction mxCostFunction3 = mxAnalysisGraph3.getGenerator().getCostFunction();
            mxGraphView mxGraphView3 = mxGraph3.getView();
            int n3 = (int)mxCostFunction3.getCost(new mxCellState(mxGraphView3, mxAnalysisGraph3.getTerminal(object2, true), null));
            int n4 = (int)mxCostFunction3.getCost(new mxCellState(mxGraphView3, mxAnalysisGraph3.getTerminal(object2, false), null));
            int n5 = 0;
            while (n3 != n || n4 != n2) {
                object2 = objectArray2[++n5];
                n3 = Integer.parseInt((String)mxGraphModel2.getValue(mxAnalysisGraph3.getTerminal(object2, true)));
                n4 = Integer.parseInt((String)mxGraphModel2.getValue(mxAnalysisGraph3.getTerminal(object2, false)));
            }
            mxGraph3.removeCells(new Object[]{object2}, true);
            Object[][] objectArray3 = mxGraphStructure.getGraphComponents(mxAnalysisGraph2);
            Object[][] objectArray4 = mxGraphStructure.getGraphComponents(mxAnalysisGraph3);
            if (objectArray4.length > objectArray3.length) {
                return true;
            }
        }
        return false;
    }

    public static Object[] getCutEdges(mxAnalysisGraph mxAnalysisGraph2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = mxAnalysisGraph2.getChildEdges(mxAnalysisGraph2.getGraph().getDefaultParent());
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!mxGraphStructure.isCutEdge(mxAnalysisGraph2, objectArray[i])) continue;
            arrayList.add(objectArray[i]);
        }
        return arrayList.toArray();
    }

    public static Object[] getSourceVertices(mxAnalysisGraph mxAnalysisGraph2) throws StructuralException {
        if (!mxGraphProperties.isDirected(mxAnalysisGraph2.getProperties(), mxGraphProperties.DEFAULT_DIRECTED)) {
            throw new StructuralException("The graph is undirected, so it can't have source vertices.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxAnalysisGraph2.getGraph().getDefaultParent());
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Object[] objectArray2 = mxAnalysisGraph2.getEdges(objectArray[i], null, false, true, true, true);
            Object[] objectArray3 = mxAnalysisGraph2.getEdges(objectArray[i], null, true, false, true, true);
            if (objectArray3.length != 0 || objectArray2.length <= 0) continue;
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public static Object[] getSinkVertices(mxAnalysisGraph mxAnalysisGraph2) throws StructuralException {
        if (!mxGraphProperties.isDirected(mxAnalysisGraph2.getProperties(), mxGraphProperties.DEFAULT_DIRECTED)) {
            throw new StructuralException("The graph is undirected, so it can't have sink vertices.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = mxAnalysisGraph2.getChildVertices(mxAnalysisGraph2.getGraph().getDefaultParent());
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Object[] objectArray2 = mxAnalysisGraph2.getEdges(objectArray[i], null, false, true, true, true);
            Object[] objectArray3 = mxAnalysisGraph2.getEdges(objectArray[i], null, true, false, true, true);
            if (objectArray3.length <= 0 || objectArray2.length != 0) continue;
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public static boolean isBiconnected(mxAnalysisGraph mxAnalysisGraph2) {
        int n = mxAnalysisGraph2.getChildEdges(mxAnalysisGraph2.getGraph().getDefaultParent()).length;
        return mxGraphStructure.getCutVertices(mxAnalysisGraph2).length == 0 && n >= 1;
    }
}

