/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.actions.base;

import com.mxgraph.swing.mxGraphComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.GraphActionManager;
import org.scilab.modules.gui.bridge.checkboxmenuitem.SwingScilabCheckBoxMenuItem;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.checkboxmenuitem.CheckBoxMenuItem;
import org.scilab.modules.gui.checkboxmenuitem.ScilabCheckBoxMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;

public abstract class DefaultAction
extends CommonCallBack {
    private final WeakReference<ScilabGraph> scilabGraph;

    public DefaultAction(ScilabGraph scilabGraph) {
        super("");
        this.scilabGraph = new WeakReference<ScilabGraph>(scilabGraph);
        this.installProperties();
    }

    private void installProperties() {
        String string = "";
        ImageIcon imageIcon = null;
        int n = 0;
        int n2 = 0;
        try {
            string = (String)((Object)((Object)this)).getClass().getField("NAME").get(null);
            String string2 = (String)((Object)((Object)this)).getClass().getField("SMALL_ICON").get(null);
            if (string2 != null && !string2.isEmpty()) {
                imageIcon = new ImageIcon(FindIconHelper.findIcon((String)string2));
            }
            n = ((Object)((Object)this)).getClass().getField("MNEMONIC_KEY").getInt(null);
            n2 = ((Object)((Object)this)).getClass().getField("ACCELERATOR_KEY").getInt(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        assert (!"".equals(string));
        this.putValue("Name", string);
        this.putValue("ShortDescription", string);
        this.putValue("LongDescription", string);
        if (imageIcon != null) {
            this.putValue("SmallIcon", imageIcon);
        }
        if (n != 0) {
            this.putValue("MnemonicKey", n);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(n, n2));
        }
    }

    protected static MenuItem createMenu(ScilabGraph scilabGraph, Class<? extends DefaultAction> clazz) {
        DefaultAction defaultAction = GraphActionManager.getInstance(scilabGraph, clazz);
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        SwingScilabMenuItem swingScilabMenuItem = (SwingScilabMenuItem)menuItem.getAsSimpleMenuItem();
        swingScilabMenuItem.setAction((Action)((Object)defaultAction));
        return menuItem;
    }

    protected static JButton createButton(ScilabGraph scilabGraph, Class<? extends DefaultAction> clazz) {
        DefaultAction defaultAction = GraphActionManager.getInstance(scilabGraph, clazz);
        JButton jButton = new JButton();
        jButton.setAction((Action)((Object)defaultAction));
        jButton.setHideActionText(true);
        return jButton;
    }

    protected static CheckBoxMenuItem createCheckBoxMenu(ScilabGraph scilabGraph, Class<? extends DefaultAction> clazz) {
        DefaultAction defaultAction = GraphActionManager.getInstance(scilabGraph, clazz);
        CheckBoxMenuItem checkBoxMenuItem = ScilabCheckBoxMenuItem.createCheckBoxMenuItem();
        SwingScilabCheckBoxMenuItem swingScilabCheckBoxMenuItem = (SwingScilabCheckBoxMenuItem)checkBoxMenuItem.getAsSimpleCheckBoxMenuItem();
        swingScilabCheckBoxMenuItem.setAction((Action)((Object)defaultAction));
        return checkBoxMenuItem;
    }

    @Deprecated
    protected DefaultAction(String string, ScilabGraph scilabGraph) {
        super(string);
        this.scilabGraph = new WeakReference<ScilabGraph>(scilabGraph);
    }

    protected final ScilabGraph getGraph(ActionEvent actionEvent) {
        ScilabGraph scilabGraph = (ScilabGraph)((Object)this.scilabGraph.get());
        if (scilabGraph != null) {
            return scilabGraph;
        }
        if (actionEvent == null) {
            return null;
        }
        if (actionEvent.getSource() instanceof Component) {
            Component component;
            for (component = (Component)actionEvent.getSource(); component != null && !(component instanceof mxGraphComponent); component = component.getParent()) {
            }
            return (ScilabGraph)((mxGraphComponent)component).getGraph();
        }
        return null;
    }

    @Deprecated
    protected static MenuItem createMenu(String string, String string2, DefaultAction defaultAction, KeyStroke keyStroke) {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback((CommonCallBack)defaultAction);
        menuItem.setText(string);
        if (keyStroke != null) {
            ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(keyStroke);
        }
        return menuItem;
    }

    public abstract void actionPerformed(ActionEvent var1);

    public void callBack() {
        assert ("Must never be called as we bypass Callback.java".equals(""));
    }
}

