/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.actions.base;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.KeyStroke;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;

public final class GraphActionManager {
    private static Map<ScilabGraph, Set<DefaultAction>> perGraphAction = new WeakHashMap<ScilabGraph, Set<DefaultAction>>();
    private static Set<DefaultAction> nullGraphAction = Collections.newSetFromMap(new WeakHashMap());

    private GraphActionManager() {
    }

    public static <T extends DefaultAction> T getInstance(ScilabGraph scilabGraph, Class<T> clazz) {
        Set<DefaultAction> set = GraphActionManager.getActionSet(scilabGraph);
        for (DefaultAction defaultAction : set) {
            if (((Object)((Object)defaultAction)).getClass() != clazz) continue;
            return (T)((Object)defaultAction);
        }
        Object object = null;
        try {
            object = (DefaultAction)((Object)clazz.getConstructor(ScilabGraph.class).newInstance(new Object[]{scilabGraph}));
            set.add((DefaultAction)((Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return (T)object;
    }

    private static Set<DefaultAction> getActionSet(ScilabGraph scilabGraph) {
        Set<DefaultAction> set;
        if (scilabGraph == null) {
            set = nullGraphAction;
        } else if (perGraphAction.containsKey((Object)scilabGraph)) {
            set = perGraphAction.get((Object)scilabGraph);
        } else {
            set = Collections.newSetFromMap(new WeakHashMap());
            perGraphAction.put(scilabGraph, set);
        }
        return set;
    }

    public static <T extends DefaultAction> T get(ScilabGraph scilabGraph, Class<T> clazz) {
        Set<DefaultAction> set = GraphActionManager.getActionSet(scilabGraph);
        for (DefaultAction defaultAction : set) {
            if (((Object)((Object)defaultAction)).getClass() != clazz) continue;
            return (T)((Object)defaultAction);
        }
        return null;
    }

    public static void setEnable(Class<? extends DefaultAction> clazz, boolean bl) {
        for (DefaultAction object : nullGraphAction) {
            if (!clazz.isInstance((Object)object)) continue;
            object.setEnabled(bl);
        }
        for (Set set : perGraphAction.values()) {
            for (DefaultAction defaultAction : set) {
                if (!clazz.isInstance((Object)defaultAction)) continue;
                defaultAction.setEnabled(bl);
            }
        }
    }

    public static boolean getEnable(Class<? extends DefaultAction> clazz) {
        boolean bl = true;
        for (DefaultAction object : nullGraphAction) {
            if (!clazz.isInstance((Object)object)) continue;
            bl &= object.isEnabled();
        }
        for (Set set : perGraphAction.values()) {
            for (DefaultAction defaultAction : set) {
                if (!clazz.isInstance((Object)defaultAction)) continue;
                bl &= defaultAction.isEnabled();
            }
        }
        return bl;
    }

    public static void updateActionKeyStroke(Class<? extends DefaultAction> clazz, KeyStroke keyStroke) {
        Set<Map.Entry<ScilabGraph, Set<DefaultAction>>> set = perGraphAction.entrySet();
        for (Map.Entry<ScilabGraph, Set<DefaultAction>> entry : set) {
            GraphActionManager.setKeyStroke(entry.getValue(), clazz, keyStroke);
        }
        GraphActionManager.setKeyStroke(nullGraphAction, clazz, keyStroke);
    }

    private static final void setKeyStroke(Set<DefaultAction> set, Class<? extends DefaultAction> clazz, KeyStroke keyStroke) {
        for (DefaultAction defaultAction : set) {
            if (((Object)((Object)defaultAction)).getClass() != clazz) continue;
            defaultAction.putValue("AcceleratorKey", keyStroke);
        }
    }
}

