/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.filechooser;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class FileMask
extends FileFilter {
    private Vector<String> filters = new Vector();
    private String description = null;
    private String fullDescription = null;

    public FileMask() {
    }

    public FileMask(String string, String string2) {
        this();
        this.filters.add(string.toLowerCase());
        this.description = string2;
    }

    public FileMask(String[] stringArray, String string) {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.filters.add(stringArray[i]);
        }
        this.description = string;
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory() || this.filters.size() == 0) {
                return true;
            }
            String string = FileMask.getExtension(file);
            if (string != null && this.filters.contains(string)) {
                return true;
            }
        }
        return false;
    }

    public static String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public String getExtensionFromFilter() {
        if (this.filters != null && this.filters.size() > 0) {
            return this.filters.elementAt(0);
        }
        return null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null && this.description == null) {
            this.fullDescription = this.description == null ? "(" : this.description + " (";
            Enumeration<String> enumeration = this.filters.elements();
            if (enumeration != null && enumeration.hasMoreElements()) {
                this.fullDescription = this.fullDescription + "." + enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    this.fullDescription = this.fullDescription + ", ." + enumeration.nextElement();
                }
            }
            return this.fullDescription + ")";
        }
        return this.description;
    }

    public void clearExtensions() {
        this.filters.clear();
    }
}

