/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.tab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.activation.ActiveDockableTracker;
import org.flexdock.docking.event.DockingEvent;
import org.flexdock.docking.props.PropertyChangeListenerFactory;
import org.flexdock.view.Titlebar;
import org.flexdock.view.View;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graphic_objects.axes.AxesContainer;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.bridge.canvas.SwingScilabCanvas;
import org.scilab.modules.gui.bridge.console.SwingScilabConsole;
import org.scilab.modules.gui.bridge.helpbrowser.SwingScilabHelpBrowser;
import org.scilab.modules.gui.bridge.menubar.SwingScilabMenuBar;
import org.scilab.modules.gui.bridge.tab.SwingScilabAxes;
import org.scilab.modules.gui.bridge.tab.SwingScilabCommonPanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabScrollPane;
import org.scilab.modules.gui.bridge.tree.SwingScilabTree;
import org.scilab.modules.gui.bridge.uidisplaytree.SwingScilabUiDisplayTree;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.canvas.Canvas;
import org.scilab.modules.gui.console.Console;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.dockable.Dockable;
import org.scilab.modules.gui.editor.EditorEventListener;
import org.scilab.modules.gui.events.GlobalEventWatcher;
import org.scilab.modules.gui.events.ScilabEventListener;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.helpbrowser.HelpBrowser;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.tree.Tree;
import org.scilab.modules.gui.uidisplaytree.UiDisplayTree;
import org.scilab.modules.gui.utils.BarUpdater;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.SciClosingAction;
import org.scilab.modules.gui.utils.SciHelpOnComponentAction;
import org.scilab.modules.gui.utils.SciUndockingAction;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabDockablePanel
extends View
implements SimpleTab,
FocusListener,
KeyListener,
SwingScilabPanel {
    private static final Image SCILAB_ICON = new ImageIcon(FindIconHelper.findIcon((String)"scilab", (String)"256x256")).getImage();
    private static final long serialVersionUID = 1L;
    private static final String UNDOCK = "undock";
    private static final String HELP = "help";
    protected boolean hasLayout = false;
    private Integer id;
    private boolean eventEnabled = false;
    ComponentListener componentListener;
    private String parentWindowId;
    private MenuBar menuBar;
    private ToolBar toolBar;
    private TextBox infoBar;
    private String helpID;
    private boolean paintEnable = true;
    private JLayeredPane uiContentPane;
    private JLayeredPane layeredPane;
    private SwingScilabScrollPane scrolling;
    private Image icon;
    private Action closeAction;
    private ScilabEventListener eventHandler;
    private EditorEventListener editorEventHandler = null;
    private SwingScilabCanvas contentCanvas = null;
    private Dimension deltaSize = null;

    public SwingScilabDockablePanel(String string, String string2) {
        super(string2, string, string);
        this.addAction("activeWindow");
        this.contentPane = null;
        this.uiContentPane = null;
        this.scrolling = null;
        this.setVisible(true);
        this.getTitlebar().addFocusListener((FocusListener)this);
        this.addFocusListener(this);
        this.setCallback(null);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("shift F6"), "togglePreviousView");
    }

    public SwingScilabDockablePanel(String string, int n) {
        super(string, string, string);
        this.addAction("activeWindow");
        this.setVisible(true);
        this.getTitlebar().addFocusListener((FocusListener)this);
        this.addFocusListener(this);
        this.setCallback(null);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("shift F6"), "togglePreviousView");
    }

    public SwingScilabDockablePanel(String string) {
        this(string, string);
    }

    public void setAssociatedXMLIDForHelp(String string) {
        this.helpID = string;
    }

    public String getAssociatedXMLIDForHelp() {
        return this.helpID;
    }

    public static void removeActions(SwingScilabDockablePanel swingScilabDockablePanel) {
        swingScilabDockablePanel.setActionBlocked("close", true);
        swingScilabDockablePanel.setActionBlocked(UNDOCK, true);
        if (swingScilabDockablePanel.getTitlebar() != null) {
            swingScilabDockablePanel.getTitlebar().revalidate();
        }
    }

    public static void addActions(SwingScilabDockablePanel swingScilabDockablePanel) {
        swingScilabDockablePanel.setActionBlocked("close", false);
        swingScilabDockablePanel.setActionBlocked(UNDOCK, false);
        swingScilabDockablePanel.getTitlebar().revalidate();
    }

    public SwingScilabDockablePanel(String string, int n, Figure figure) {
        this(string, n);
        this.editorEventHandler = new EditorEventListener(figure.getIdentifier());
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setLayout(null);
        this.layeredPane.setBorder(null);
        this.layeredPane.setOpaque(true);
        this.uiContentPane = new JLayeredPane();
        this.uiContentPane.setOpaque(false);
        this.uiContentPane.setLayout(null);
        this.uiContentPane.setBorder(null);
        this.layeredPane.add(this.uiContentPane, JLayeredPane.DEFAULT_LAYER + 1, 0);
        this.scrolling = new SwingScilabScrollPane((Component)this.layeredPane, this.uiContentPane, figure);
        this.setContentPane(this.scrolling.getAsContainer());
        this.uiContentPane.setVisible(true);
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent hierarchyEvent) {
            }

            @Override
            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                if (hierarchyEvent.getChanged() instanceof SwingScilabWindow) {
                    Position position = SwingScilabWindow.allScilabWindows.get(SwingScilabDockablePanel.this.parentWindowId).getPosition();
                    Integer[] integerArray = new Integer[]{position.getX(), position.getY()};
                    GraphicController.getController().setProperty(SwingScilabDockablePanel.this.id, 80, (Object)integerArray);
                }
            }
        });
        this.componentListener = new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Integer[] integerArray;
                Size size = SwingScilabWindow.allScilabWindows.get(SwingScilabDockablePanel.this.parentWindowId).getDims();
                Integer[] integerArray2 = new Integer[]{size.getWidth(), size.getHeight()};
                GraphicController.getController().setProperty(SwingScilabDockablePanel.this.id, 81, (Object)integerArray2);
                Boolean bl = (Boolean)GraphicController.getController().getProperty(SwingScilabDockablePanel.this.id, 83);
                if (bl != null && bl.booleanValue()) {
                    integerArray = new Integer[]{SwingScilabDockablePanel.this.getContentPane().getWidth(), SwingScilabDockablePanel.this.getContentPane().getHeight()};
                    GraphicController.getController().setProperty(SwingScilabDockablePanel.this.id, 85, (Object)integerArray);
                }
                if ((integerArray = (Integer[])GraphicController.getController().getProperty(SwingScilabDockablePanel.this.id, 101)) != null && !integerArray.equals("")) {
                    String string = "if exists(\"gcbo\") then %oldgcbo = gcbo; end;gcbo = getcallbackobject(" + SwingScilabDockablePanel.this.id + ");" + (String)integerArray + ";if exists(\"%oldgcbo\") then gcbo = %oldgcbo; else clear gcbo; end;";
                    InterpreterManagement.requestScilabExec((String)string);
                } else if (!SwingScilabDockablePanel.this.hasLayout) {
                    for (Component component : SwingScilabDockablePanel.this.getWidgetPane().getComponents()) {
                        if (!(component instanceof Widget)) continue;
                        Widget widget = (Widget)((Object)component);
                        SwingViewObject swingViewObject = (SwingViewObject)((Object)component);
                        SwingViewWidget.update(widget, 80, GraphicController.getController().getProperty(swingViewObject.getId(), 80));
                    }
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        };
        this.addComponentListener(this.componentListener);
        ClosingOperationsManager.registerClosingOperation(this, new ClosingOperationsManager.ClosingOperation(){

            @Override
            public int canClose() {
                String string = (String)GraphicController.getController().getProperty(SwingScilabDockablePanel.this.getId(), 102);
                if (string != null && !string.equals("")) {
                    String string2 = "if exists(\"gcbo\") then %oldgcbo = gcbo; end;gcbo = getcallbackobject(" + SwingScilabDockablePanel.this.getId() + ");" + string + ";fire_closing_finished();;if exists(\"%oldgcbo\") then gcbo = %oldgcbo; else clear gcbo; end;";
                    InterpreterManagement.requestScilabExec((String)string2);
                    return -1;
                }
                SwingScilabDockablePanel.this.closeAction.actionPerformed(null);
                return 1;
            }

            @Override
            public void destroy() {
            }

            @Override
            public String askForClosing(List<SwingScilabDockablePanel> list) {
                return null;
            }

            @Override
            public void updateDependencies(List<SwingScilabDockablePanel> list, ListIterator<SwingScilabDockablePanel> listIterator) {
            }
        });
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.contentPane != null) {
            this.contentPane.requestFocus();
        } else if (this.getContentPane() != null) {
            this.getContentPane().requestFocus();
        } else {
            this.requestFocusInWindow();
        }
    }

    public void endedRestoration() {
    }

    public Image getWindowIcon() {
        if (this.icon == null) {
            return SCILAB_ICON;
        }
        return this.icon;
    }

    public void setWindowIcon(Image image) {
        this.icon = image;
    }

    @Override
    public void setWindowIcon(String string) {
        this.setWindowIcon(new ImageIcon(FindIconHelper.findIcon((String)string, (String)"256x256")).getImage());
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public void dockingComplete(DockingEvent dockingEvent) {
        super.dockingComplete(dockingEvent);
        DockingPort dockingPort = dockingEvent.getNewDockingPort();
        SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)dockingPort);
        Iterator iterator = dockingPort.getDockables().iterator();
        if (dockingPort.getDockables().size() > 1) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SwingScilabDockablePanel)) continue;
                SwingScilabDockablePanel swingScilabDockablePanel = (SwingScilabDockablePanel)e;
                SwingScilabDockablePanel.addActions(swingScilabDockablePanel);
            }
        } else {
            SwingScilabDockablePanel.removeActions(this);
        }
        if (swingScilabWindow != null) {
            this.setParentWindowId(swingScilabWindow.getId());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SwingScilabDockablePanel.this.getParentWindow() != null) {
                        SwingScilabDockablePanel.this.setParentWindowId(SwingScilabDockablePanel.this.getParentWindow().getId());
                    } else {
                        System.err.println("No window for tab:" + SwingScilabDockablePanel.this.getClass().getName() + " after docking complete");
                    }
                }
            });
        }
    }

    @Override
    public void setName(String string) {
        this.setTitle(string, true);
        this.getTitlePane().repaint();
        SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)this)).setName(string);
    }

    public String getParentWindowUUID() {
        return ((SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)this))).getUUID();
    }

    @Override
    public SwingScilabWindow getParentWindow() {
        return (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)this));
    }

    @Override
    public String getName() {
        return this.getTitle();
    }

    public void paintImmediately() {
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void draw() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setVisible(true);
            this.paintImmediately();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SwingScilabDockablePanel.this.setVisible(true);
                        SwingScilabDockablePanel.this.paintImmediately();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    @Override
    public Size getDims() {
        return new Size(this.getSize().width, this.getSize().height);
    }

    @Override
    public Size getAxesSize() {
        return new Size(this.contentPane.getWidth(), this.contentPane.getHeight());
    }

    @Override
    public void setAxesSize(Size size) {
        this.contentPane.setSize(new Dimension(size.getWidth(), size.getHeight()));
        this.uiContentPane.setSize(new Dimension(size.getWidth(), size.getHeight()));
    }

    @Override
    public Position getPosition() {
        return new Position(this.getX(), this.getY());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        this.setLocation(position.getX(), position.getY());
    }

    @Override
    public int addMember(Canvas canvas) {
        return 0;
    }

    @Override
    public void removeMember(Canvas canvas) {
    }

    @Override
    public void addMember(SwingViewObject swingViewObject) {
        if (swingViewObject instanceof SwingScilabAxes) {
            if (this.contentCanvas == null) {
                this.contentCanvas = new SwingScilabCanvas((AxesContainer)((Figure)GraphicController.getController().getObjectFromId(((SwingScilabAxes)swingViewObject).getFigureId())));
                this.contentCanvas.addEventHandlerKeyListener(this.editorEventHandler);
                this.contentCanvas.addEventHandlerMouseListener(this.editorEventHandler);
                this.contentCanvas.addEventHandlerMouseMotionListener(this.editorEventHandler);
                if (this.eventEnabled) {
                    this.editorEventHandler.setEnable(false);
                    this.enableEventHandler();
                }
                this.layeredPane.add((Component)this.contentCanvas, JLayeredPane.FRAME_CONTENT_LAYER);
                this.scrolling.setCanvas(this.contentCanvas);
                this.contentCanvas.addKeyListener(this);
            }
            return;
        }
        SwingScilabCommonPanel.addMember(this, swingViewObject);
    }

    @Override
    public void removeMember(SwingViewObject swingViewObject) {
        SwingScilabCommonPanel.removeMember(this, swingViewObject);
    }

    @Override
    public int addMember(Console console) {
        return this.addMember((SwingScilabConsole)console.getAsSimpleConsole());
    }

    private int addMember(SwingScilabConsole swingScilabConsole) {
        this.setContentPane((Container)((Object)swingScilabConsole));
        return this.getComponentZOrder((Component)((Object)swingScilabConsole));
    }

    @Override
    public int addMember(HelpBrowser helpBrowser) {
        return this.addMember((SwingScilabHelpBrowser)helpBrowser.getAsSimpleHelpBrowser());
    }

    private int addMember(SwingScilabHelpBrowser swingScilabHelpBrowser) {
        this.setContentPane(swingScilabHelpBrowser);
        return this.getComponentZOrder(swingScilabHelpBrowser);
    }

    @Override
    public int addMember(UiDisplayTree uiDisplayTree) {
        return this.addMember((SwingScilabUiDisplayTree)uiDisplayTree.getAsSimpleUiDisplayTree());
    }

    private int addMember(SwingScilabUiDisplayTree swingScilabUiDisplayTree) {
        return 0;
    }

    @Override
    public void removeMember(UiDisplayTree uiDisplayTree) {
        this.removeMember((SwingScilabUiDisplayTree)uiDisplayTree.getAsSimpleUiDisplayTree());
    }

    private void removeMember(SwingScilabUiDisplayTree swingScilabUiDisplayTree) {
    }

    @Override
    public int addMember(Tree tree) {
        return this.addMember((SwingScilabTree)tree.getAsSimpleTree());
    }

    public int addMember(SwingScilabTree swingScilabTree) {
        return 0;
    }

    public int addTree(SwingScilabTree swingScilabTree) {
        this.setContentPane(swingScilabTree.getAsComponent());
        return this.getComponentZOrder(swingScilabTree.getAsComponent());
    }

    @Override
    public void removeMember(Tree tree) {
        this.removeMember((SwingScilabTree)tree.getAsSimpleTree());
    }

    private void removeMember(SwingScilabTree swingScilabTree) {
    }

    public int addMember(Dockable dockable) {
        return 0;
    }

    @Override
    public boolean isCurrentTab() {
        return true;
    }

    @Override
    public String getParentWindowId() {
        return this.parentWindowId;
    }

    public SwingScilabCanvas getContentCanvas() {
        return this.contentCanvas;
    }

    @Override
    public void setParentWindowId(String string) {
        this.parentWindowId = string;
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
        if (this.menuBar != menuBar) {
            if (this.menuBar != null) {
                ((SwingScilabMenuBar)this.menuBar.getAsSimpleMenuBar()).close();
            }
            this.menuBar = menuBar;
        }
    }

    @Override
    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public void setToolBar(ToolBar toolBar) {
        this.toolBar = toolBar;
    }

    @Override
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public void setInfoBar(TextBox textBox) {
        this.infoBar = textBox;
    }

    @Override
    public TextBox getInfoBar() {
        return this.infoBar;
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        if (this.closeAction != null) {
            this.getTitlebar().removeAction(this.closeAction);
        }
        this.closeAction = commonCallBack != null ? new SciClosingAction(this, commonCallBack) : new SciClosingAction(this);
        this.closeAction.putValue("Name", "close");
        ((Titlebar)this.getTitlePane()).removeAction("close");
        this.addAction(this.closeAction);
        SciUndockingAction sciUndockingAction = new SciUndockingAction(this);
        sciUndockingAction.putValue("Name", UNDOCK);
        ((Titlebar)this.getTitlePane()).removeAction(UNDOCK);
        this.addAction(sciUndockingAction);
        SciHelpOnComponentAction sciHelpOnComponentAction = new SciHelpOnComponentAction(this);
        sciHelpOnComponentAction.putValue("Name", HELP);
        ((Titlebar)this.getTitlePane()).removeAction(HELP);
        this.addAction(sciHelpOnComponentAction);
    }

    @Override
    public void setCurrent() {
        ActiveDockableTracker.requestDockableActivation((Component)((Object)this));
    }

    @Override
    public void setBackground(double d, double d2, double d3) {
        Color color = new Color((float)d, (float)d2, (float)d3);
        this.setBackground(color);
    }

    @Override
    public int[] getViewingRegion() {
        return this.scrolling.getViewingRegion();
    }

    @Override
    public void setViewingRegion(int n, int n2, int n3, int n4) {
    }

    @Override
    public void setEventHandler(String string) {
        this.disableEventHandler();
        this.eventHandler = new ScilabEventListener(string, this.getId(), false);
        if (this.eventEnabled) {
            this.editorEventHandler.setEnable(false);
            this.enableEventHandler();
        }
    }

    @Override
    public void setEventHandlerEnabled(boolean bl) {
        if (bl && this.eventEnabled) {
            return;
        }
        if (bl) {
            this.editorEventHandler.setEnable(false);
            this.enableEventHandler();
            this.eventEnabled = true;
        } else {
            this.editorEventHandler.setEnable(true);
            this.disableEventHandler();
            this.eventEnabled = false;
        }
    }

    @Override
    public void setAutoResizeMode(boolean bl) {
    }

    @Override
    public boolean getAutoResizeMode() {
        return true;
    }

    @Override
    public void close() {
        if (this.getTitlePane() != null) {
            ((Titlebar)this.getTitlePane()).removeAction("close");
            ((Titlebar)this.getTitlePane()).removeAction(UNDOCK);
            ((Titlebar)this.getTitlePane()).removeAction(HELP);
        }
        if (this.closeAction != null) {
            this.getTitlebar().removeAction(this.closeAction);
            if (this.closeAction instanceof SciClosingAction) {
                ((SciClosingAction)this.closeAction).clean();
            }
            this.closeAction = null;
        }
        this.setMenuBar(null);
        this.setToolBar(null);
        this.setInfoBar(null);
        this.setTitlebar(null);
        this.removeAll();
        this.scrolling = null;
        this.contentPane = null;
        DockingManager.unregisterDockable((Component)((Object)this));
        Container container = new Container();
        this.setContentPane(container);
        if (this.editorEventHandler != null) {
            this.editorEventHandler.onExit();
        }
    }

    public void disablePaint() {
        this.paintEnable = false;
    }

    @Override
    public void setFigureBackground(Color color) {
        if (this.layeredPane != null) {
            this.layeredPane.setBackground(color);
        }
    }

    public void paintChildren(Graphics graphics) {
        if (this.paintEnable) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i].isLightweight()) continue;
                componentArray[i].paint(graphics);
            }
            super.paintChildren(graphics);
        }
    }

    @Override
    public void update(int n, Object object) {
        SwingScilabCommonPanel.update(this, n, object);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer n) {
        this.id = n;
    }

    private void enableEventHandler() {
        if (this.contentCanvas != null) {
            this.contentCanvas.addEventHandlerKeyListener(this.eventHandler);
            this.contentCanvas.addEventHandlerMouseListener(this.eventHandler);
            this.contentCanvas.addEventHandlerMouseMotionListener(this.eventHandler);
        }
    }

    private void disableEventHandler() {
        if (this.eventHandler != null && this.contentCanvas != null) {
            this.contentCanvas.removeEventHandlerKeyListener(this.eventHandler);
            this.contentCanvas.removeEventHandlerMouseListener(this.eventHandler);
            this.contentCanvas.removeEventHandlerMouseMotionListener(this.eventHandler);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!(!ScilabConstants.isGUI() || this.eventHandler != null && this.eventEnabled || GlobalEventWatcher.isActivated() || this.editorEventHandler.isDatatipEnable() || !Character.isLetterOrDigit(keyEvent.getKeyChar()))) {
            SwingScilabConsole swingScilabConsole = (SwingScilabConsole)ScilabConsole.getConsole().getAsSimpleConsole();
            JTextPane jTextPane = (JTextPane)swingScilabConsole.getConfiguration().getInputCommandView();
            jTextPane.requestFocus();
            SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)swingScilabConsole));
            swingScilabWindow.toFront();
            jTextPane.dispatchEvent(new KeyEvent(jTextPane, 400, System.currentTimeMillis(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
        }
    }

    @Override
    public JLayeredPane getWidgetPane() {
        return this.uiContentPane;
    }

    @Override
    public void setHasLayout(boolean bl) {
        this.hasLayout = bl;
    }

    @Override
    public void applyDeltaSize() {
        if (this.deltaSize != null) {
            if (this.deltaSize.getWidth() != 0.0 || this.deltaSize.getHeight() != 0.0) {
                SwingScilabWindow swingScilabWindow = SwingScilabWindow.allScilabWindows.get(this.getParentWindowId());
                Dimension dimension = this.getContentPane().getSize();
                swingScilabWindow.setDims(new Size((int)(dimension.getWidth() + this.deltaSize.getWidth()), (int)(dimension.getHeight() + this.deltaSize.getHeight())));
            }
            this.deltaSize = null;
        }
    }

    @Override
    public void storeSizeDelta() {
        Dimension dimension = this.getContentPane().getSize();
        SwingScilabWindow swingScilabWindow = SwingScilabWindow.allScilabWindows.get(this.getParentWindowId());
        Size size = swingScilabWindow.getDims();
        this.deltaSize = new Dimension((int)((double)size.getWidth() - dimension.getWidth()), (int)((double)size.getHeight() - dimension.getHeight()));
    }

    @Override
    public void disableResizeEvent() {
        this.removeComponentListener(this.componentListener);
    }

    @Override
    public void enableResizeEvent() {
        this.addComponentListener(this.componentListener);
    }

    static {
        PropertyChangeListenerFactory.addFactory((PropertyChangeListenerFactory)new BarUpdater.UpdateBarFactory());
    }
}

