/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.tab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JScrollPane;
import org.scilab.modules.graphic_objects.figure.ColorMap;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicView.GraphicView;
import org.scilab.modules.gui.bridge.canvas.SwingScilabCanvas;
import org.scilab.modules.gui.bridge.tab.ScilabScrollPane;
import org.scilab.modules.renderer.JoGLView.util.ColorFactory;

public class SwingScilabScrollPane
extends JScrollPane
implements ScilabScrollPane,
GraphicView {
    private static final long serialVersionUID = -4262585651413643814L;
    private SwingScilabCanvas canvas;
    private Figure figure;
    private Component comp;
    private Container uiContent;

    public SwingScilabScrollPane(Component component, Container container, Figure figure) {
        super(component);
        this.comp = component;
        this.uiContent = container;
        this.figure = figure;
        this.setBorder(null);
        GraphicController.getController().register((GraphicView)this);
        if (figure.getAutoResize().booleanValue()) {
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(21);
        } else {
            this.setHorizontalScrollBarPolicy(30);
            this.setVerticalScrollBarPolicy(20);
        }
    }

    @Override
    public int[] getViewingRegion() {
        Rectangle rectangle = this.getViewport().getViewRect();
        int[] nArray = new int[]{(int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight()};
        return nArray;
    }

    @Override
    public void setBackground(double d, double d2, double d3) {
        Color color = new Color((float)d, (float)d2, (float)d3);
        this.setRealBackground(color);
    }

    private void setRealBackground(Color color) {
        this.getViewport().setBackground(color);
    }

    @Override
    public void setViewPosition(int n, int n2) {
        this.getViewport().setViewPosition(new Point(n, n2));
    }

    @Override
    public Container getAsContainer() {
        return this;
    }

    public void updateObject(Integer n, int n2) {
        if (this.figure.getIdentifier().equals(n)) {
            Serializable serializable;
            if (n2 == 83) {
                serializable = (Boolean)GraphicController.getController().getProperty(n, n2);
                if (serializable.booleanValue()) {
                    this.setHorizontalScrollBarPolicy(31);
                    this.setVerticalScrollBarPolicy(21);
                } else {
                    this.setHorizontalScrollBarPolicy(30);
                    this.setVerticalScrollBarPolicy(20);
                }
            }
            if (n2 == 85) {
                serializable = new Dimension(this.figure.getAxesSize()[0], this.figure.getAxesSize()[1]);
                this.comp.setPreferredSize((Dimension)serializable);
                this.comp.setSize((Dimension)serializable);
                this.uiContent.setSize((Dimension)serializable);
                this.uiContent.setPreferredSize((Dimension)serializable);
                if (this.canvas != null) {
                    this.canvas.setBounds(0, 0, this.figure.getAxesSize()[0], this.figure.getAxesSize()[1]);
                }
            }
            if (n2 == 96) {
                if (this.canvas != null) {
                    this.canvas.setBackground((Color)ColorFactory.createColor((ColorMap)this.figure.getColorMap(), (int)this.figure.getBackground()));
                } else {
                    this.uiContent.setBackground((Color)ColorFactory.createColor((ColorMap)this.figure.getColorMap(), (int)this.figure.getBackground()));
                }
            }
        }
    }

    public void setCanvas(SwingScilabCanvas swingScilabCanvas) {
        this.canvas = swingScilabCanvas;
        if (swingScilabCanvas != null) {
            this.setRealBackground(swingScilabCanvas.getBackground());
        }
    }

    public Component getGlobalComponent() {
        return this.comp;
    }

    public Container getUIComponent() {
        return this.uiContent;
    }

    public void createObject(Integer n) {
    }

    public void deleteObject(Integer n) {
        if (this.figure.getIdentifier().equals(n)) {
            GraphicController.getController().unregister((GraphicView)this);
        }
    }
}

