/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.editor;

import java.util.HashMap;
import java.util.Map;
import org.scilab.modules.graphic_objects.ScilabNativeView;
import org.scilab.modules.gui.editor.Editor;

public class EditorManager {
    private static Map<Integer, Editor> allEditors = new HashMap<Integer, Editor>();

    public static Editor newEditor(Integer n) {
        Editor editor = new Editor();
        editor.setFigure(n);
        allEditors.put(n, editor);
        return editor;
    }

    public static void start(int n) {
        EditorManager.enableModify(ScilabNativeView.ScilabNativeView__getFigureFromIndex((int)n));
    }

    public static void stop(int n) {
        EditorManager.disableModify(ScilabNativeView.ScilabNativeView__getFigureFromIndex((int)n));
    }

    public static void enableModify(int n) {
        Editor editor = allEditors.get(n);
        if (editor != null) {
            editor.setDataModifyEnabled(true);
        }
    }

    public static void disableModify(int n) {
        Editor editor = allEditors.get(n);
        if (editor != null) {
            editor.setDataModifyEnabled(false);
        }
    }

    public static boolean isModifyEnabled(int n) {
        Editor editor = allEditors.get(n);
        if (editor != null) {
            return editor.isDataModifyEnabled();
        }
        return false;
    }

    public static void deleteEditor(int n) {
        allEditors.remove(n);
    }

    public static Editor getFromUid(int n) {
        return allEditors.get(n);
    }
}

