/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public final class ScilabFontUtils {
    private static Graphics2D g2d;
    private static int defaultFontSize;

    public static void setDefaultFontSize(int n) {
        defaultFontSize = n;
    }

    public static String[][] getMonospacedFontsFamillyName() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (ScilabFontUtils.isMonospaced(stringArray[i])) {
                arrayList.add(stringArray[i]);
                continue;
            }
            arrayList2.add(stringArray[i]);
        }
        return new String[][]{arrayList.toArray(new String[0]), arrayList2.toArray(new String[0])};
    }

    public static String[][] getAllStylesSameWidthsFontsFamillyName() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (ScilabFontUtils.isAllStylesSameWidths(stringArray[i])) {
                arrayList.add(stringArray[i]);
                continue;
            }
            arrayList2.add(stringArray[i]);
        }
        return new String[][]{arrayList.toArray(new String[0]), arrayList2.toArray(new String[0])};
    }

    public static boolean isAllStylesSameWidths(String string) {
        return ScilabFontUtils.isAllStylesSameWidths(new Font(string, 0, defaultFontSize));
    }

    public static boolean isAllStylesSameWidths(Font font) {
        int[] nArray = new int[]{0, 1, 2, 3};
        FontMetrics fontMetrics = g2d.getFontMetrics(font.deriveFont(nArray[0]));
        int[] nArray2 = fontMetrics.getWidths();
        for (int i = 1; i < nArray.length; ++i) {
            fontMetrics = g2d.getFontMetrics(font.deriveFont(nArray[i]));
            int[] nArray3 = fontMetrics.getWidths();
            for (int j = 33; j < 126; ++j) {
                if (nArray3[j] == nArray2[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isMonospaced(String string) {
        return ScilabFontUtils.isMonospaced(new Font(string, 0, defaultFontSize));
    }

    public static boolean isMonospaced(Font font) {
        int[] nArray = g2d.getFontMetrics(font).getWidths();
        int n = nArray[97];
        for (int i = 33; i < 127; ++i) {
            if (nArray[i] == n) continue;
            return false;
        }
        return true;
    }

    static {
        defaultFontSize = 14;
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        g2d = bufferedImage.createGraphics();
    }
}

