/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

public class CefSettings {
    public String browser_subprocess_path = null;
    public boolean windowless_rendering_enabled = true;
    public boolean command_line_args_disabled = false;
    public String cache_path = null;
    public String root_cache_path = null;
    public boolean persist_session_cookies = false;
    public String user_agent = null;
    public String user_agent_product = null;
    public String locale = null;
    public String log_file = null;
    public LogSeverity log_severity = LogSeverity.LOGSEVERITY_DEFAULT;
    public String javascript_flags = null;
    public String resources_dir_path = null;
    public String locales_dir_path = null;
    public int remote_debugging_port = 0;
    public int uncaught_exception_stack_size = 0;
    public ColorType background_color = null;
    public String cookieable_schemes_list = null;
    public boolean cookieable_schemes_exclude_defaults = false;

    public CefSettings clone() {
        CefSettings cefSettings = new CefSettings();
        cefSettings.browser_subprocess_path = this.browser_subprocess_path;
        cefSettings.windowless_rendering_enabled = this.windowless_rendering_enabled;
        cefSettings.command_line_args_disabled = this.command_line_args_disabled;
        cefSettings.cache_path = this.cache_path;
        cefSettings.root_cache_path = this.root_cache_path;
        cefSettings.persist_session_cookies = this.persist_session_cookies;
        cefSettings.user_agent = this.user_agent;
        cefSettings.user_agent_product = this.user_agent_product;
        cefSettings.locale = this.locale;
        cefSettings.log_file = this.log_file;
        cefSettings.log_severity = this.log_severity;
        cefSettings.javascript_flags = this.javascript_flags;
        cefSettings.resources_dir_path = this.resources_dir_path;
        cefSettings.locales_dir_path = this.locales_dir_path;
        cefSettings.remote_debugging_port = this.remote_debugging_port;
        cefSettings.uncaught_exception_stack_size = this.uncaught_exception_stack_size;
        if (this.background_color != null) {
            cefSettings.background_color = this.background_color.clone();
        }
        cefSettings.cookieable_schemes_list = this.cookieable_schemes_list;
        cefSettings.cookieable_schemes_exclude_defaults = this.cookieable_schemes_exclude_defaults;
        return cefSettings;
    }

    public static enum LogSeverity {
        LOGSEVERITY_DEFAULT,
        LOGSEVERITY_VERBOSE,
        LOGSEVERITY_INFO,
        LOGSEVERITY_WARNING,
        LOGSEVERITY_ERROR,
        LOGSEVERITY_FATAL,
        LOGSEVERITY_DISABLE;

    }

    public class ColorType {
        private long color_value = 0L;

        private ColorType() {
        }

        public ColorType(int n, int n2, int n3, int n4) {
            this.color_value = n << 24 | n2 << 16 | n3 << 8 | n4 << 0;
        }

        public long getColor() {
            return this.color_value;
        }

        public ColorType clone() {
            ColorType colorType = new ColorType();
            colorType.color_value = this.color_value;
            return colorType;
        }
    }
}

