/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import org.scilab.modules.scinotes.ScilabDocument;

public class CompoundUndoManager
extends UndoManager {
    private static final long serialVersionUID = 2400488911410627080L;
    private CompoundEdit compoundEdit;
    private ScilabDocument sdoc;
    private Segment seg = new Segment();
    private boolean remove;
    private int nbEdits;
    private char[] breaks;
    private int prevLine;
    private boolean oneShot;

    public CompoundUndoManager(ScilabDocument scilabDocument) {
        this.sdoc = scilabDocument;
        this.setLimit(-1);
        this.setBreakingChars(" \n");
    }

    public void setBreakingChars(String string) {
        this.breaks = string.toCharArray();
    }

    public String getBreakingChars() {
        return new String(this.breaks);
    }

    public void startCompoundEdit() {
        if (this.compoundEdit == null && this.sdoc.getEditorPane() != null) {
            this.compoundEdit = new CompoundEdit();
            this.addEdit(this.compoundEdit);
            ++this.nbEdits;
            if (this.sdoc.getEditorPane().getEditor() != null) {
                this.sdoc.getEditorPane().getEditor().enableUndoButton(true);
            }
        }
    }

    public void endCompoundEdit() {
        if (this.compoundEdit != null && this.sdoc.getEditorPane() != null) {
            this.compoundEdit.end();
            this.compoundEdit = null;
        }
    }

    public void enableOneShot(boolean bl) {
        this.oneShot = bl;
    }

    @Override
    public void undo() {
        this.endCompoundEdit();
        try {
            super.undo();
            if (this.sdoc.getEditorPane().getEditor() != null) {
                this.sdoc.getEditorPane().getEditor().enableRedoButton(true);
            }
            --this.nbEdits;
            if (this.nbEdits == 0) {
                this.sdoc.setContentModified(false);
            }
            if (!this.canUndo() && this.sdoc.getEditorPane().getEditor() != null) {
                this.sdoc.getEditorPane().getEditor().enableUndoButton(false);
            }
        }
        catch (CannotUndoException cannotUndoException) {
            return;
        }
    }

    @Override
    public void redo() {
        this.endCompoundEdit();
        try {
            super.redo();
            if (this.sdoc.getEditorPane().getEditor() != null) {
                this.sdoc.getEditorPane().getEditor().enableUndoButton(true);
            }
            ++this.nbEdits;
            if (this.nbEdits == 0) {
                this.sdoc.setContentModified(false);
            }
            if (!this.canRedo() && this.sdoc.getEditorPane().getEditor() != null) {
                this.sdoc.getEditorPane().getEditor().enableRedoButton(false);
            }
        }
        catch (CannotRedoException cannotRedoException) {
            return;
        }
    }

    public void enableUndoRedoButtons() {
        this.endCompoundEdit();
        if (this.sdoc.getEditorPane().getEditor() != null) {
            this.sdoc.getEditorPane().getEditor().enableRedoButton(this.canRedo());
            this.sdoc.getEditorPane().getEditor().enableUndoButton(this.canUndo());
        }
    }

    public boolean isAtReference() {
        return this.nbEdits == 0;
    }

    public void setReference() {
        this.nbEdits = 0;
    }

    @Override
    public void discardAllEdits() {
        this.endCompoundEdit();
        super.discardAllEdits();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEditEvent.getEdit();
        if (this.sdoc.getEditorPane() != null) {
            if (!this.oneShot && defaultDocumentEvent.getLength() == 1) {
                if (!this.remove && defaultDocumentEvent.getType() == DocumentEvent.EventType.REMOVE) {
                    this.endCompoundEdit();
                    this.remove = true;
                }
                if (this.remove && defaultDocumentEvent.getType() == DocumentEvent.EventType.INSERT) {
                    this.endCompoundEdit();
                    this.remove = false;
                }
                try {
                    this.sdoc.getText(defaultDocumentEvent.getOffset(), 1, this.seg);
                    boolean bl = false;
                    for (int i = 0; i < this.breaks.length && !bl; ++i) {
                        bl = this.seg.array[this.seg.offset] == this.breaks[i];
                    }
                    if (!this.remove && bl) {
                        this.endCompoundEdit();
                        this.startCompoundEdit();
                        this.compoundEdit.addEdit(undoableEditEvent.getEdit());
                        this.endCompoundEdit();
                        return;
                    }
                    if (this.sdoc.getDefaultRootElement().getElementIndex(defaultDocumentEvent.getOffset()) != this.prevLine) {
                        this.prevLine = this.sdoc.getDefaultRootElement().getElementIndex(defaultDocumentEvent.getOffset());
                        this.endCompoundEdit();
                    }
                    this.startCompoundEdit();
                    this.compoundEdit.addEdit(undoableEditEvent.getEdit());
                    return;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            } else {
                this.startCompoundEdit();
                this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            }
        }
    }
}

