/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.scilab.modules.scinotes.KeywordAdapter;
import org.scilab.modules.scinotes.KeywordEvent;
import org.scilab.modules.scinotes.MatchingBlockScanner;
import org.scilab.modules.scinotes.SciNotesConfiguration;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.ScilabLexerConstants;

public class MatchingBlockManager {
    private ScilabDocument doc;
    private ScilabEditorPane pane;
    private MatchingBlockScanner scanner;
    private Highlighter highlighter;
    private MatchingBlockScanner.MatchingPositions smpos;
    private Highlighter.HighlightPainter kwPainter;
    private Highlighter.HighlightPainter ocPainter;
    private Object first;
    private Object second;
    private boolean insideOc;
    private boolean insideKw;
    private boolean ocIncluded;
    private boolean kwIncluded;
    private boolean lr;
    private boolean isOCMouseover;
    private boolean isKWMouseover;
    private MouseOverMatcher mouseover;

    public MatchingBlockManager(ScilabDocument scilabDocument, ScilabEditorPane scilabEditorPane, boolean bl, Highlighter highlighter) {
        this.doc = scilabDocument;
        this.pane = scilabEditorPane;
        this.scanner = new MatchingBlockScanner(scilabDocument);
        this.highlighter = highlighter;
        this.lr = bl;
    }

    public MatchingBlockScanner getScanner() {
        return this.scanner;
    }

    public void setPainterForOpenClose(boolean bl, boolean bl2, Color color) {
        this.insideOc = true;
        this.ocIncluded = bl2;
        this.update();
        this.ocPainter = new InsideLinePainter(bl, false, color);
    }

    public void setPainterForOpenClose(int n, Color color) {
        this.insideOc = false;
        this.update();
        this.ocPainter = new ScilabKeywordsPainter(color, n);
    }

    public void setPainterForOpenClose() {
        this.setPainterForOpenClose(SciNotesOptions.getSciNotesDisplay().bracketsHighlightment, SciNotesOptions.getSciNotesDisplay().bracketsColor);
        if (SciNotesOptions.getSciNotesDisplay().bracketsOnmouseover) {
            this.isOCMouseover = true;
            this.activateMouseOver();
        } else {
            this.isOCMouseover = false;
            this.disableMouseOver();
        }
    }

    public void setPainterForKeywords(boolean bl, boolean bl2, boolean bl3, Color color) {
        this.insideKw = true;
        this.kwIncluded = bl3;
        this.update();
        this.kwPainter = new InsideLinePainter(bl, bl2, color);
    }

    public void setPainterForKeywords(int n, Color color) {
        this.insideKw = false;
        this.update();
        this.kwPainter = new ScilabKeywordsPainter(color, n);
    }

    public void setPainterForKeywords() {
        this.setPainterForKeywords(SciNotesOptions.getSciNotesDisplay().keywordsHighlightment == 0, true, false, SciNotesOptions.getSciNotesDisplay().keywordsColor);
        if (SciNotesOptions.getSciNotesDisplay().keywordsOnmouseover) {
            this.isKWMouseover = true;
            this.activateMouseOver();
        } else {
            this.isKWMouseover = false;
            this.disableMouseOver();
        }
    }

    public void setDefaults() {
        if (SciNotesOptions.getSciNotesDisplay().highlightKeywords) {
            this.setPainterForKeywords();
        }
        if (SciNotesOptions.getSciNotesDisplay().highlightBrackets) {
            this.setPainterForOpenClose();
        }
    }

    public void configurationChanged(SciNotesConfiguration.Conf conf) {
        if (conf.display) {
            this.setDefaults();
        }
    }

    public void activateMouseOver() {
        if (this.mouseover == null) {
            this.mouseover = new MouseOverMatcher();
        }
        this.pane.addKeywordListener(this.mouseover);
    }

    public void disableMouseOver() {
        if (this.mouseover != null && !this.isOCMouseover && !this.isKWMouseover) {
            this.pane.removeKeywordListener(this.mouseover);
            this.mouseover = null;
        }
    }

    public void desactivateMouseOver() {
        if (this.mouseover != null) {
            this.pane.removeKeywordListener(this.mouseover);
            this.mouseover = null;
        }
    }

    public synchronized void update() {
        if (this.first != null) {
            this.highlighter.removeHighlight(this.first);
            this.first = null;
        }
        if (this.second != null) {
            this.highlighter.removeHighlight(this.second);
            this.second = null;
        }
    }

    public synchronized void searchMatchingBlock(boolean bl, int n, int n2) {
        MatchingBlockScanner.MatchingPositions matchingPositions = null;
        if (ScilabLexerConstants.isMatchable(n)) {
            matchingPositions = this.scanner.getMatchingBlock(n2, this.lr);
        }
        if (matchingPositions != this.smpos) {
            this.smpos = matchingPositions;
            try {
                if (this.first != null) {
                    this.highlighter.removeHighlight(this.first);
                    if (this.second != null) {
                        this.highlighter.removeHighlight(this.second);
                    }
                }
                if (matchingPositions != null) {
                    if (ScilabLexerConstants.isOpenClose(n) && this.ocPainter != null && (!bl || this.isOCMouseover)) {
                        this.createHighlights(matchingPositions, this.insideOc, this.ocIncluded, this.ocPainter);
                    } else if (this.kwPainter != null && (!bl || this.isKWMouseover)) {
                        this.createHighlights(matchingPositions, this.insideKw, this.kwIncluded, this.kwPainter);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private void createHighlights(MatchingBlockScanner.MatchingPositions matchingPositions, boolean bl, boolean bl2, Highlighter.HighlightPainter highlightPainter) {
        try {
            if (!bl) {
                this.first = this.highlighter.addHighlight(matchingPositions.firstB, matchingPositions.firstE, highlightPainter);
                this.second = this.highlighter.addHighlight(matchingPositions.secondB, matchingPositions.secondE, highlightPainter);
            } else {
                this.first = this.lr ? (bl2 ? this.highlighter.addHighlight(matchingPositions.firstB, matchingPositions.secondE, highlightPainter) : this.highlighter.addHighlight(matchingPositions.firstE, matchingPositions.secondB, highlightPainter)) : (bl2 ? this.highlighter.addHighlight(matchingPositions.secondB, matchingPositions.firstE, highlightPainter) : this.highlighter.addHighlight(matchingPositions.secondE, matchingPositions.firstB, highlightPainter));
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
    }

    class InsideLinePainter
    implements Highlighter.HighlightPainter {
        private boolean filled;
        private boolean strict;
        private Color color;

        protected InsideLinePainter(boolean bl, boolean bl2, Color color) {
            this.filled = bl;
            this.strict = bl2;
            this.color = color;
        }

        @Override
        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            try {
                Rectangle rectangle = shape.getBounds();
                Rectangle rectangle2 = jTextComponent.modelToView(n);
                Rectangle rectangle3 = jTextComponent.modelToView(n2);
                graphics.setColor(this.color);
                if (rectangle2.y == rectangle3.y) {
                    Rectangle rectangle4 = rectangle2.union(rectangle3);
                    if (this.filled) {
                        graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    } else {
                        graphics.drawRect(rectangle4.x, rectangle4.y, rectangle4.width - 1, rectangle4.height - 1);
                    }
                } else {
                    Element element = MatchingBlockManager.this.doc.getDefaultRootElement();
                    int n3 = element.getElementIndex(n);
                    int n4 = element.getElementIndex(n2);
                    Rectangle rectangle5 = jTextComponent.modelToView(element.getElement(n3).getEndOffset());
                    Rectangle rectangle6 = jTextComponent.modelToView(element.getElement(n4).getStartOffset());
                    if (n3 != n4) {
                        if (!this.strict) {
                            if (this.filled) {
                                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle.width, rectangle2.height);
                                graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle5.y - rectangle2.y - rectangle2.height);
                                if (rectangle6.y != rectangle3.y) {
                                    graphics.fillRect(rectangle6.x, rectangle6.y, rectangle.width, rectangle6.height);
                                }
                                graphics.fillRect(rectangle6.x, rectangle3.y, rectangle3.x, rectangle6.height);
                            } else {
                                graphics.drawRect(rectangle2.x, rectangle2.y, rectangle.width - 1, rectangle2.height - 1);
                                graphics.drawRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width - 1, rectangle5.y - rectangle2.y - rectangle2.height - 1);
                                if (rectangle6.y != rectangle3.y) {
                                    graphics.drawRect(rectangle6.x, rectangle6.y, rectangle.width, rectangle6.height - 1);
                                }
                                graphics.drawRect(rectangle6.x, rectangle3.y, rectangle3.x, rectangle6.height - 1);
                            }
                        }
                        if (this.filled) {
                            graphics.fillRect(rectangle.x, rectangle5.y, rectangle.width, rectangle6.y - rectangle5.y);
                        } else {
                            graphics.drawRect(rectangle.x, rectangle5.y, rectangle.width - 1, rectangle6.y - rectangle5.y - 1);
                        }
                    } else {
                        int n5 = rectangle.x + rectangle.width - rectangle2.x;
                        if (this.filled) {
                            graphics.fillRect(rectangle2.x, rectangle2.y, n5, rectangle2.height);
                            if (rectangle2.y + rectangle2.height != rectangle3.y) {
                                graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - (rectangle2.y + rectangle2.height));
                            }
                            graphics.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                        } else {
                            graphics.drawRect(rectangle2.x, rectangle2.y, n5 - 1, rectangle2.height - 1);
                            if (rectangle2.y + rectangle2.height != rectangle3.y) {
                                graphics.drawRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width - 1, rectangle3.y - (rectangle2.y + rectangle2.height) - 1);
                            }
                            graphics.drawRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x - 1, rectangle3.height - 1);
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public class ScilabKeywordsPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public static final int FILLED = 0;
        public static final int UNDERLINED = 1;
        public static final int FRAMED = 2;
        private Color color;
        private int type;

        public ScilabKeywordsPainter(Color color, int n) {
            super(color);
            this.color = color;
            this.type = n;
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            try {
                Rectangle rectangle = (Rectangle)view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                graphics.setColor(this.color);
                switch (this.type) {
                    case 1: {
                        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                        return rectangle;
                    }
                    case 2: {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                        return rectangle;
                    }
                }
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                return rectangle;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }

    class MouseOverMatcher
    extends KeywordAdapter.MouseOverAdapter {
        MouseOverMatcher() {
        }

        @Override
        public void caughtKeyword(KeywordEvent keywordEvent) {
            if (MatchingBlockManager.this.lr) {
                MatchingBlockManager.this.searchMatchingBlock(true, keywordEvent.getType(), keywordEvent.getStart());
            } else {
                MatchingBlockManager.this.searchMatchingBlock(true, keywordEvent.getType(), keywordEvent.getStart() + keywordEvent.getLength());
            }
        }
    }

    public static class Parameters {
        public Color color;
        public boolean inside;
        public boolean strict;
        public boolean included;
        public int type;
        public boolean onmouseover;

        public Parameters(Color color, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.color = color;
            this.inside = bl;
            this.type = n;
            this.strict = bl2;
            this.included = bl3;
            this.onmouseover = bl4;
        }
    }
}

