/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.io.IOException;
import javax.swing.KeyStroke;
import javax.swing.text.Element;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.ScilabLexer;
import org.scilab.modules.scinotes.ScilabLexerConstants;
import org.scilab.modules.scinotes.actions.DefaultAction;

public final class DoubleQuoteStringAction
extends DefaultAction {
    private static final long serialVersionUID = 1L;

    public DoubleQuoteStringAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        ScilabEditorPane scilabEditorPane = this.getEditor().getTextPane();
        ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
        scilabDocument.getUndoManager().enableOneShot(true);
        scilabDocument.mergeEditsBegin();
        DoubleQuoteStringAction.doubleQuoteString(scilabDocument);
        scilabDocument.mergeEditsEnd();
        scilabDocument.getUndoManager().enableOneShot(false);
    }

    public static void doubleQuoteString(ScilabDocument scilabDocument) {
        StringBuffer stringBuffer = new StringBuffer(128);
        ScilabLexer scilabLexer = scilabDocument.createLexer(false);
        Element element = scilabDocument.getDefaultRootElement();
        int n = element.getElementIndex(scilabDocument.getLength());
        try {
            for (int i = 0; i <= n; ++i) {
                int n2;
                Element element2 = element.getElement(i);
                scilabLexer.setRange(element2.getStartOffset(), element2.getEndOffset());
                do {
                    if (ScilabLexerConstants.isString(n2 = scilabLexer.scan())) {
                        stringBuffer.append(scilabDocument.getText(scilabLexer.start + scilabLexer.yychar(), scilabLexer.yylength()));
                        continue;
                    }
                    if (stringBuffer.length() <= 0) continue;
                    boolean bl = false;
                    int n3 = stringBuffer.length();
                    if (stringBuffer.charAt(0) == '\'') {
                        stringBuffer.replace(0, 1, "\"");
                        bl = true;
                    }
                    if (n3 > 1 && stringBuffer.charAt(n3 - 1) == '\'') {
                        stringBuffer.replace(n3 - 1, n3, "\"");
                        bl = true;
                    }
                    if (bl) {
                        int n4 = scilabLexer.start + scilabLexer.yychar() - n3;
                        scilabDocument.replace(n4, n3, stringBuffer.toString(), null);
                    }
                    stringBuffer.setLength(0);
                } while (n2 != 35);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public static SciNotes.ActionOnDocument getActionOnDocument() {
        return new SciNotes.ActionOnDocument(){

            @Override
            public void actionOn(ScilabDocument scilabDocument) throws IOException {
                DoubleQuoteStringAction.doubleQuoteString(scilabDocument);
            }
        };
    }

    public static MenuItem createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        return DoubleQuoteStringAction.createMenu(string, null, new DoubleQuoteStringAction(string, sciNotes), keyStroke);
    }
}

