/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.console.AdvCLIManagement;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.history_manager.HistoryManagement;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.actions.DefaultAction;

public final class EvaluateSelectionAction
extends DefaultAction {
    private static final long serialVersionUID = 320938663765236236L;

    public EvaluateSelectionAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        ScilabEditorPane scilabEditorPane = this.getEditor().getTextPane();
        String string = scilabEditorPane.getCodeToExecute();
        if (string.compareTo("") != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            if (ScilabConsole.isExistingConsole()) {
                HistoryManagement.appendLinesToScilabHistory((String[])stringArray, (int)stringArray.length);
                ScilabConsole.getConsole().getAsSimpleConsole().sendCommandsToScilab(string, true, false);
            } else {
                new Thread(() -> {
                    try {
                        System.out.println(string);
                        ScilabInterpreterManagement.synchronousScilabExec((String)string);
                        System.out.println();
                        System.out.print(AdvCLIManagement.GetCurrentPrompt());
                    }
                    catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
                        System.out.println(interpreterException.getMessage());
                    }
                }).start();
            }
        }
    }

    public static MenuItem createMenu(String string, final SciNotes sciNotes, KeyStroke keyStroke) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";\uff1b");
        final String string2 = stringTokenizer.nextToken();
        final String string3 = stringTokenizer.nextToken();
        final MenuItem menuItem = EvaluateSelectionAction.createMenu(string2, null, new EvaluateSelectionAction(string2, sciNotes), keyStroke);
        if (!ScilabConsole.isExistingConsole()) {
            ((JMenuItem)menuItem.getAsSimpleMenuItem()).setEnabled(false);
        }
        ((JMenuItem)menuItem.getAsSimpleMenuItem()).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (sciNotes.getTextPane() != null) {
                    String string = sciNotes.getTextPane().getSelectedText();
                    if (string == null) {
                        menuItem.setText(string3);
                    } else {
                        menuItem.setText(string2);
                    }
                }
            }
        });
        return menuItem;
    }
}

