/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import org.scilab.modules.gui.bridge.menu.SwingScilabMenu;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.actions.DefaultAction;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;

public class RecentFileAction
extends DefaultAction {
    private static Map<SciNotes, Menu> menus = new HashMap<SciNotes, Menu>();
    private File recentFile;

    public RecentFileAction(SciNotes sciNotes, File file) {
        super(file.getName(), sciNotes);
        this.recentFile = file;
    }

    @Override
    public void doAction() {
        ConfigSciNotesManager.saveToRecentOpenedFiles(this.recentFile.getPath());
        this.getEditor().readFile(this.recentFile);
        this.getEditor().setTitle(this.recentFile.getPath() + " - SciNotes");
    }

    public static void close(SciNotes sciNotes) {
        menus.remove((Object)sciNotes);
    }

    public static MenuItem createMenu(SciNotes sciNotes, File file) {
        return RecentFileAction.createMenu(file.getName(), null, new RecentFileAction(sciNotes, file), null);
    }

    public static Menu createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        Menu menu = ScilabMenu.createMenu();
        menu.setText(string);
        menus.put(sciNotes, menu);
        RecentFileAction.updateRecentOpenedFilesMenu(sciNotes);
        return menu;
    }

    public static void updateRecentOpenedFilesMenu() {
        List<File> list = ConfigSciNotesManager.getAllRecentOpenedFiles();
        for (SciNotes sciNotes : menus.keySet()) {
            Menu menu = menus.get((Object)sciNotes);
            if (menu == null) continue;
            ((SwingScilabMenu)menu.getAsSimpleMenu()).removeAll();
            int n = Math.max(0, list.size() - SciNotesOptions.getSciNotesPreferences().numberOfRecentlyOpen);
            for (int i = list.size() - 1; i >= n; --i) {
                menu.add(RecentFileAction.createMenu(sciNotes, list.get(i)));
            }
        }
    }

    public static void updateRecentOpenedFilesMenu(SciNotes sciNotes) {
        List<File> list = ConfigSciNotesManager.getAllRecentOpenedFiles();
        Menu menu = menus.get((Object)sciNotes);
        if (menu != null) {
            ((SwingScilabMenu)menu.getAsSimpleMenu()).removeAll();
            int n = Math.max(0, list.size() - SciNotesOptions.getSciNotesPreferences().numberOfRecentlyOpen);
            for (int i = list.size() - 1; i >= n; --i) {
                menu.add(RecentFileAction.createMenu(sciNotes, list.get(i)));
            }
        }
    }
}

