/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.scinotes.EditorComponent;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.actions.DefaultAction;

public final class SplitAction
extends DefaultAction {
    private static final long serialVersionUID = 1L;
    private int state;

    public SplitAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        switch (this.state) {
            case 0: {
                this.getEditor().removeSplit();
                return;
            }
            case 1: {
                this.getEditor().splitTab(false);
                return;
            }
        }
        this.getEditor().splitTab(true);
    }

    public static Menu createMenu(String string, final SciNotes sciNotes, KeyStroke keyStroke) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";\uff1b");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        SplitAction splitAction = new SplitAction(string2, sciNotes);
        Menu menu = ScilabMenu.createMenu();
        menu.setText(string2);
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButtonMenuItem[] jRadioButtonMenuItemArray = new JRadioButtonMenuItem[3];
        String[] stringArray = new String[]{string3, string4, string5};
        for (int i = 0; i < 3; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = SplitAction.createRadioButtonMenuItem(splitAction, stringArray[i], i);
            buttonGroup.add(jRadioButtonMenuItem);
            ((JMenu)menu.getAsSimpleMenu()).add(jRadioButtonMenuItem);
            jRadioButtonMenuItemArray[i] = jRadioButtonMenuItem;
        }
        jRadioButtonMenuItemArray[0].setSelected(true);
        ((JMenu)menu.getAsSimpleMenu()).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (sciNotes.getTextPane() != null) {
                    EditorComponent editorComponent = sciNotes.getTextPane().getEditorComponent();
                    int n = 0;
                    if (editorComponent.isSplited()) {
                        JSplitPane jSplitPane = editorComponent.getSplitPane();
                        n = jSplitPane.getOrientation() == 1 ? 1 : 2;
                    }
                    jRadioButtonMenuItemArray[n].setSelected(true);
                }
            }
        });
        return menu;
    }

    private static JRadioButtonMenuItem createRadioButtonMenuItem(final SplitAction splitAction, String string, final int n) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                splitAction.state = n;
                splitAction.doAction();
            }
        });
        return jRadioButtonMenuItem;
    }
}

