/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail.name;

import com.sourcetrail.name.NameElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class NameHierarchy {
    private List<NameElement> m_elements = new ArrayList<NameElement>();
    private char m_separator = (char)46;

    public NameHierarchy() {
    }

    public NameHierarchy(String name) {
        this.m_elements.add(new NameElement(name));
    }

    public NameHierarchy(NameElement name) {
        this.m_elements.add(name);
    }

    public NameHierarchy(List<NameElement> names) {
        this.m_elements.addAll(names);
    }

    public void setSeparator(char separator) {
        this.m_separator = separator;
    }

    public void push(NameElement element) {
        this.m_elements.add(element);
    }

    public void pop() {
        if (!this.m_elements.isEmpty()) {
            this.m_elements.remove(this.m_elements.size() - 1);
        }
    }

    public Optional<NameElement> peek() {
        if (!this.m_elements.isEmpty()) {
            return Optional.of(this.m_elements.get(this.m_elements.size() - 1));
        }
        return Optional.empty();
    }

    public String serialize() {
        String serialized = this.m_separator + "\tm";
        for (int i = 0; i < this.m_elements.size(); ++i) {
            if (i != 0) {
                serialized = serialized + "\tn";
            }
            serialized = serialized + this.m_elements.get(i).serialize();
        }
        return serialized;
    }
}

