/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail.name.resolver;

import com.sourcetrail.ContextList;
import java.io.File;
import java.util.Optional;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public abstract class NameResolver {
    protected File m_currentFile = null;
    protected ContextList m_ignoredContexts = null;
    protected CompilationUnit m_compilationUnit = null;

    protected static <N> Optional<N> getAncestorOfType(ASTNode node, Class<N> classType) {
        for (ASTNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!classType.isAssignableFrom(parent.getClass())) continue;
            return Optional.of(classType.cast(parent));
        }
        return Optional.empty();
    }

    public NameResolver(File currentFile, CompilationUnit compilationUnit, ContextList ignoredContexts) {
        this.m_currentFile = currentFile;
        this.m_compilationUnit = compilationUnit;
        this.m_ignoredContexts = ignoredContexts != null ? ignoredContexts : new ContextList();
    }
}

