/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail;

import com.sourcetrail.AccessKind;
import com.sourcetrail.AstVisitorClient;
import com.sourcetrail.DefinitionKind;
import com.sourcetrail.JavaIndexer;
import com.sourcetrail.Range;
import com.sourcetrail.ReferenceKind;
import com.sourcetrail.SymbolKind;
import com.sourcetrail.name.NameElement;
import com.sourcetrail.name.NameHierarchy;

public class JavaIndexerAstVisitorClient
extends AstVisitorClient {
    private int m_address;
    private String m_javaLangPackageName;
    private boolean m_javaLangPackageRecorded;

    public JavaIndexerAstVisitorClient(int address) {
        this.m_address = address;
        NameHierarchy javaLangPackageNameHierarchy = new NameHierarchy();
        javaLangPackageNameHierarchy.push(new NameElement("java"));
        javaLangPackageNameHierarchy.push(new NameElement("lang"));
        this.m_javaLangPackageName = javaLangPackageNameHierarchy.serialize();
        this.m_javaLangPackageRecorded = false;
    }

    @Override
    public boolean getInterrupted() {
        return JavaIndexer.getInterrupted(this.m_address);
    }

    @Override
    public void logInfo(String info) {
        JavaIndexer.logInfo(this.m_address, info);
    }

    @Override
    public void logWarning(String warning) {
        JavaIndexer.logWarning(this.m_address, warning);
    }

    @Override
    public void logError(String error) {
        JavaIndexer.logError(this.m_address, error);
    }

    @Override
    public void recordSymbol(NameHierarchy symbolName, SymbolKind symbolKind, AccessKind access, DefinitionKind definitionKind) {
        JavaIndexer.recordSymbol(this.m_address, symbolName.serialize(), symbolKind.getValue(), access.getValue(), definitionKind.getValue());
    }

    @Override
    public void recordSymbolWithLocation(NameHierarchy symbolName, SymbolKind symbolKind, Range range, AccessKind access, DefinitionKind definitionKind) {
        JavaIndexer.recordSymbolWithLocation(this.m_address, symbolName.serialize(), symbolKind.getValue(), range.begin.line(), range.begin.column(), range.end.line(), range.end.column(), access.getValue(), definitionKind.getValue());
    }

    @Override
    public void recordSymbolWithLocationAndScope(NameHierarchy symbolName, SymbolKind symbolKind, Range range, Range scopeRange, AccessKind access, DefinitionKind definitionKind) {
        JavaIndexer.recordSymbolWithLocationAndScope(this.m_address, symbolName.serialize(), symbolKind.getValue(), range.begin.line(), range.begin.column(), range.end.line(), range.end.column(), scopeRange.begin.line(), scopeRange.begin.column(), scopeRange.end.line(), scopeRange.end.column(), access.getValue(), definitionKind.getValue());
    }

    @Override
    public void recordSymbolWithLocationAndScopeAndSignature(NameHierarchy symbolName, SymbolKind symbolKind, Range range, Range scopeRange, Range signatureRange, AccessKind access, DefinitionKind definitionKind) {
        JavaIndexer.recordSymbolWithLocationAndScopeAndSignature(this.m_address, symbolName.serialize(), symbolKind.getValue(), range.begin.line(), range.begin.column(), range.end.line(), range.end.column(), scopeRange.begin.line(), scopeRange.begin.column(), scopeRange.end.line(), scopeRange.end.column(), signatureRange.begin.line(), signatureRange.begin.column(), signatureRange.end.line(), signatureRange.end.column(), access.getValue(), definitionKind.getValue());
    }

    @Override
    public void recordReference(ReferenceKind referenceKind, NameHierarchy referencedName, NameHierarchy contextName, Range range) {
        String serializedReferencedName = referencedName.serialize();
        if (!this.m_javaLangPackageRecorded && serializedReferencedName.startsWith(this.m_javaLangPackageName)) {
            JavaIndexer.recordSymbol(this.m_address, this.m_javaLangPackageName, SymbolKind.PACKAGE.getValue(), AccessKind.NONE.getValue(), DefinitionKind.NONE.getValue());
            this.m_javaLangPackageRecorded = true;
        }
        JavaIndexer.recordReference(this.m_address, referenceKind.getValue(), serializedReferencedName, contextName.serialize(), range.begin.line(), range.begin.column(), range.end.line(), range.end.column());
    }

    @Override
    public void recordQualifierLocation(NameHierarchy qualifierName, Range range) {
        JavaIndexer.recordQualifierLocation(this.m_address, qualifierName.serialize(), range.begin.line(), range.begin.column(), range.end.line(), range.end.column());
    }

    @Override
    public void recordLocalSymbol(NameHierarchy symbolName, Range range) {
        JavaIndexer.recordLocalSymbol(this.m_address, symbolName.serialize(), range.begin.line(), range.begin.column(), range.end.line(), range.end.column());
    }

    @Override
    public void recordComment(Range range) {
        JavaIndexer.recordComment(this.m_address, range.begin.line(), range.begin.column(), range.end.line(), range.end.column());
    }

    @Override
    public void recordError(String message, boolean fatal, boolean indexed, Range range) {
        JavaIndexer.recordError(this.m_address, message, fatal ? 1 : 0, indexed ? 1 : 0, range.begin.line(), range.begin.column(), range.end.line(), range.end.column());
    }
}

