/*
 * Decompiled with CFR 0.152.
 */
package com.sourcetrail.name.resolver;

import com.sourcetrail.ContextList;
import com.sourcetrail.Position;
import com.sourcetrail.Utility;
import com.sourcetrail.name.DeclName;
import com.sourcetrail.name.FunctionDeclName;
import com.sourcetrail.name.TypeName;
import com.sourcetrail.name.VariableDeclName;
import com.sourcetrail.name.resolver.BindingNameResolver;
import com.sourcetrail.name.resolver.NameResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class DeclNameResolver
extends NameResolver {
    public DeclNameResolver(File currentFile, CompilationUnit compilationUnit, ContextList ignoredContexts) {
        super(currentFile, compilationUnit, ignoredContexts);
    }

    public static DeclName getQualifiedDeclName(VariableDeclarationFragment decl, File currentFile, CompilationUnit compilationUnit) {
        return DeclNameResolver.getQualifiedDeclName(decl, currentFile, compilationUnit, null);
    }

    public static DeclName getQualifiedDeclName(VariableDeclarationFragment decl, File currentFile, CompilationUnit compilationUnit, ContextList ignoredContexts) {
        DeclNameResolver resolver = new DeclNameResolver(currentFile, compilationUnit, ignoredContexts);
        return resolver.getQualifiedDeclName(decl);
    }

    public DeclName getQualifiedDeclName(VariableDeclarationFragment decl) {
        DeclName parentDeclName;
        DeclName declName = DeclName.unsolved();
        if (decl != null && !(declName = this.getDeclName(decl)).getIsUnsolved() && (parentDeclName = this.getQualifiedContextName((ASTNode)decl)) != null) {
            if (!parentDeclName.getIsUnsolved()) {
                declName.setParent(parentDeclName);
            } else {
                declName = DeclName.unsolved();
            }
        }
        return declName;
    }

    public DeclName getDeclName(VariableDeclarationFragment decl) {
        TypeName typeName = TypeName.unsolved();
        boolean isStatic = false;
        Optional<FieldDeclaration> fieldDeclaration = DeclNameResolver.getAncestorOfType((ASTNode)decl, FieldDeclaration.class);
        if (fieldDeclaration.isPresent()) {
            isStatic = decl.resolveBinding() instanceof IVariableBinding ? Modifier.isStatic((int)decl.resolveBinding().getModifiers()) : Modifier.isStatic((int)fieldDeclaration.get().getModifiers());
            typeName = BindingNameResolver.getQualifiedName(fieldDeclaration.get().getType().resolveBinding(), this.m_currentFile, this.m_compilationUnit, this.m_ignoredContexts.copy()).orElse(TypeName.unsolved());
        }
        return new VariableDeclName(decl.getName().getIdentifier(), typeName, isStatic);
    }

    public static DeclName getQualifiedDeclName(BodyDeclaration decl, File currentFile, CompilationUnit compilationUnit) {
        return DeclNameResolver.getQualifiedDeclName(decl, currentFile, compilationUnit, null);
    }

    public static DeclName getQualifiedDeclName(BodyDeclaration decl, File currentFile, CompilationUnit compilationUnit, ContextList ignoredContexts) {
        DeclNameResolver resolver = new DeclNameResolver(currentFile, compilationUnit, ignoredContexts);
        return resolver.getQualifiedDeclName(decl);
    }

    public DeclName getQualifiedDeclName(BodyDeclaration decl) {
        DeclName parentDeclName;
        DeclName declName = DeclName.unsolved();
        if (decl != null && !(declName = this.getDeclName(decl)).getIsUnsolved() && (parentDeclName = this.getQualifiedContextName((ASTNode)decl)) != null) {
            if (!parentDeclName.getIsUnsolved()) {
                declName.setParent(parentDeclName);
            } else {
                declName = DeclName.unsolved();
            }
        }
        return declName;
    }

    public DeclName getDeclName(BodyDeclaration decl) {
        DeclName declName = DeclName.unsolved();
        if (decl != null) {
            if (decl instanceof AnnotationTypeDeclaration) {
                AnnotationTypeDeclaration annotationDecl = (AnnotationTypeDeclaration)decl;
                declName = new DeclName(annotationDecl.getName().getIdentifier());
            } else if (decl instanceof EnumDeclaration) {
                EnumDeclaration enumDecl = (EnumDeclaration)decl;
                declName = new DeclName(enumDecl.getName().getIdentifier());
            } else if (decl instanceof RecordDeclaration) {
                RecordDeclaration recordDecl = (RecordDeclaration)decl;
                declName = new DeclName(recordDecl.getName().getIdentifier());
            } else if (decl instanceof TypeDeclaration) {
                TypeDeclaration typeDeclarationDecl = (TypeDeclaration)decl;
                ArrayList<String> typeParameterNames = new ArrayList<String>();
                for (Object typeParameterDecl : typeDeclarationDecl.typeParameters()) {
                    if (!(typeParameterDecl instanceof TypeParameter)) continue;
                    TypeParameter typeParameter = (TypeParameter)typeParameterDecl;
                    typeParameterNames.add(typeParameter.getName().getIdentifier());
                }
                declName = new DeclName(typeDeclarationDecl.getName().getIdentifier(), typeParameterNames);
            } else if (decl instanceof AnnotationTypeMemberDeclaration) {
                AnnotationTypeMemberDeclaration annotationTypeMemberDecl = (AnnotationTypeMemberDeclaration)decl;
                declName = new DeclName(annotationTypeMemberDecl.getName().getIdentifier());
            } else if (decl instanceof EnumConstantDeclaration) {
                EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)decl;
                declName = new DeclName(enumConstantDecl.getName().getIdentifier());
            } else if (decl instanceof FieldDeclaration) {
                declName = new DeclName("FieldDeclaration");
            } else if (decl instanceof Initializer) {
                declName = new DeclName("Initializer");
            } else if (decl instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
                ArrayList<String> typeParameterNames = new ArrayList<String>();
                for (Object typeParameter : methodDeclaration.typeParameters()) {
                    if (!(typeParameter instanceof TypeParameter)) continue;
                    typeParameterNames.add(((TypeParameter)typeParameter).getName().getIdentifier());
                }
                ContextList ignoredContexts = this.m_ignoredContexts.copy();
                ignoredContexts.add((IBinding)((MethodDeclaration)decl).resolveBinding());
                TypeName returnTypeName = methodDeclaration.isConstructor() ? null : BindingNameResolver.getQualifiedName(methodDeclaration.getReturnType2().resolveBinding(), this.m_currentFile, this.m_compilationUnit, ignoredContexts).orElse(TypeName.unsolved());
                ArrayList<TypeName> parameterTypeNames = new ArrayList<TypeName>();
                for (Object parameter : methodDeclaration.parameters()) {
                    if (!(parameter instanceof SingleVariableDeclaration)) continue;
                    parameterTypeNames.add(BindingNameResolver.getQualifiedName(((SingleVariableDeclaration)parameter).getType().resolveBinding(), this.m_currentFile, this.m_compilationUnit, ignoredContexts).orElse(TypeName.unsolved()));
                }
                declName = new FunctionDeclName(methodDeclaration.getName().getIdentifier(), typeParameterNames, returnTypeName, parameterTypeNames, Modifier.isStatic((int)methodDeclaration.getModifiers()));
            }
        }
        return declName;
    }

    public static DeclName getQualifiedDeclName(AnonymousClassDeclaration decl, File currentFile, CompilationUnit compilationUnit) {
        return DeclNameResolver.getQualifiedDeclName(decl, currentFile, compilationUnit, null);
    }

    public static DeclName getQualifiedDeclName(AnonymousClassDeclaration decl, File currentFile, CompilationUnit compilationUnit, ContextList ignoredContexts) {
        DeclNameResolver resolver = new DeclNameResolver(currentFile, compilationUnit, ignoredContexts);
        return resolver.getQualifiedDeclName(decl);
    }

    public DeclName getQualifiedDeclName(AnonymousClassDeclaration decl) {
        DeclName parentDeclName;
        DeclName declName = DeclName.unsolved();
        if (decl != null && !(declName = this.getDeclName(decl)).getIsUnsolved() && (parentDeclName = this.getQualifiedContextName((ASTNode)decl)) != null) {
            if (!parentDeclName.getIsUnsolved()) {
                declName.setParent(parentDeclName);
            } else {
                declName = DeclName.unsolved();
            }
        }
        return declName;
    }

    public DeclName getDeclName(AnonymousClassDeclaration decl) {
        Position pos = Utility.getRange((ASTNode)decl, (CompilationUnit)this.m_compilationUnit).begin;
        return DeclName.anonymousClass(this.m_currentFile, pos.line(), pos.column());
    }

    public static DeclName getQualifiedName(Name name) {
        if (name.isSimpleName()) {
            return new DeclName(((SimpleName)name).getIdentifier());
        }
        DeclName declName = new DeclName(((QualifiedName)name).getName().getIdentifier());
        declName.setParent(DeclNameResolver.getQualifiedName(((QualifiedName)name).getQualifier()));
        return declName;
    }

    private DeclName getQualifiedContextName(ASTNode decl) {
        ASTNode parentNode = decl.getParent();
        if (parentNode == null) {
            return null;
        }
        if (parentNode instanceof BodyDeclaration && !(parentNode instanceof FieldDeclaration)) {
            return this.getQualifiedDeclName((BodyDeclaration)parentNode);
        }
        if (parentNode instanceof AnonymousClassDeclaration) {
            return this.getQualifiedDeclName((AnonymousClassDeclaration)parentNode);
        }
        if (parentNode instanceof CompilationUnit) {
            PackageDeclaration packageDecl = ((CompilationUnit)parentNode).getPackage();
            if (packageDecl != null) {
                return DeclNameResolver.getQualifiedName(packageDecl.getName());
            }
            return null;
        }
        return this.getQualifiedContextName(parentNode);
    }
}

