// this is how we will require our module
const m = require('./editor-registry.ts');

console.log('----------------------');
console.log('--Test getKeyValues--');
const currVersion = m.getKeyValues('Software\\Unity Technologies\\Unity Editor 5.x');
console.log('getKeyValues:');
console.log(`Keys: ${currVersion[0]}`);
console.log(`Values: ${currVersion[1]}`);

console.log('----------------------');
console.log('--Test getKeyValues with root (user environment variables)--');
const usrEnVars = m.getKeyValues('HKEY_CURRENT_USER\\Environment');
console.log('getKeyValues:');
console.log(`Keys: ${usrEnVars[0]}`);
console.log(`Values: ${usrEnVars[1]}`);

console.log('----------------------');
console.log('--Test getKeyValues with root (system environment variables)--');
const sysEnVars = m.getKeyValues(
  'HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment',
);
console.log('getKeyValues:');
console.log(`Keys: ${sysEnVars[0]}`);
console.log(`Values: ${sysEnVars[1]}`);

console.log('----------------------');
console.log('--Test getKeyValues with invalid path--');
const invalidTest = m.getKeyValues('HKEY_LOCAL_MACHINE\\invalid');
console.log('getKeyValues:');
console.log(`Keys: ${invalidTest[0]}`);
console.log(`Values: ${invalidTest[1]}`);

console.log('------------------');
console.log('--Test getString--');
const pid = m.getString(
  'HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\',
  'ProductId',
  'NOOONE',
);
console.log('getString for ProductId:');
console.log(`Value: ${pid}`);
console.log('Expects a value different than NOOONE');

console.log('------------------');
console.log('--Test getUInt32--');
const cv = m.getUInt32(
  'HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\',
  'CurrentMajorVersionNumber',
  7,
);
console.log('getUInt32 for CurrentMajorVersionNumber:');
console.log(`Value: ${cv}`);
console.log('Expects a value different than 7');

console.log('------------------');
console.log('--Test setString--');
const currentVal = m.getString(
  'HKEY_CURRENT_USER\\Software\\Unity\\UnityEditor\\',
  'Editor StatsDone',
  'error',
);
if (currentVal !== 'error') {
  const res = m.setString(
    'HKEY_CURRENT_USER\\Software\\Unity\\UnityEditor\\',
    'Editor StatsDone',
    'random',
  );
  console.log(`Did it write?: ${res}`);
  if (res) {
    const newVal = m.getString(
      'HKEY_CURRENT_USER\\Software\\Unity\\UnityEditor\\',
      'Editor StatsDone',
      'error',
    );
    console.log('setString for Editor StatsDone:');
    console.log(`Value: ${newVal}`);
    console.log('Expects: random');
  }
  m.setString('HKEY_CURRENT_USER\\Software\\Unity\\UnityEditor\\', 'Editor StatsDone', currentVal);
}

console.log('-------------------------------');
console.log('--Test setString without root--');
const currentVal2 = m.getString(
  'HKEY_CURRENT_USER\\Software\\Unity\\UnityEditor\\',
  'Editor StatsDone',
  'error',
);
if (currentVal2 !== 'error') {
  const res = m.setString('Software\\Unity\\UnityEditor\\', 'Editor StatsDone', 'random');
  console.log(`Did it write?: ${res}`);
  console.log('Expects: false');
}

console.log('------------------');
console.log('--Test setUInt32--');
const currentVal3 = m.getUInt32(
  'HKEY_CURRENT_USER\\Software\\Unity Technologies\\Installer\\',
  'Select_Android',
  100,
);
if (currentVal3 !== 100) {
  const res = m.setUInt32(
    'HKEY_CURRENT_USER\\Software\\Unity Technologies\\Installer\\',
    'Select_Android',
    1,
  );
  console.log(`Did it write?: ${res}`);
  if (res) {
    const newVal = m.getUInt32(
      'HKEY_CURRENT_USER\\Software\\Unity Technologies\\Installer\\',
      'Select_Android',
      0,
    );
    console.log('setUInt32 for Installer Select_Android:');
    console.log(`Value: ${newVal}`);
    console.log('Expects: 1');
  }
  m.setUInt32(
    'HKEY_CURRENT_USER\\Software\\Unity Technologies\\Installer\\',
    'Select_Android',
    currentVal3,
  );
}

console.log('-------------------------------');
console.log('--Test setUInt32 without root--');
const currentVal4 = m.getUInt32(
  'HKEY_CURRENT_USER\\Software\\Unity Technologies\\Installer\\',
  'Select_Android',
  100,
);
if (currentVal4 !== 100) {
  const res = m.setUInt32('Software\\Unity Technologies\\Installer\\', 'Select_Android', 1);
  console.log(`Did it write?: ${res}`);
  console.log('Expects: false');
}

console.log('-------------------------------');
console.log('--Test getRegistryKeyName--');
console.log(`hash key name ${m.getRegistryKeyName('RecentlyUsedProjectPaths-0')}`);
console.log('Expects: _h1085040554 for RecentlyUsedProjectPaths-0');

console.log('------------------');
console.log('--Test setRegistryValue--');
const res = m.setBinaryValue(
  'HKEY_CURRENT_USER\\Software\\Unity\\UnityEditor\\',
  'Editor Test Set Reg',
  'random',
);
console.log(`Did it write?: ${res}`);
m.setBinaryValue(
  'HKEY_CURRENT_USER\\Software\\Unity\\UnityEditor\\',
  'Editor Test Set Reg',
  'error',
);

console.log('------------------');
console.log('--Test deleteKey--');
const resSetReg = m.setBinaryValue(
  'HKEY_CURRENT_USER\\Software\\Unity\\UnityEditor\\',
  'Editor Test Del Reg',
  'random',
);
if (resSetReg) {
  const regdel = m.deleteKey(
    'HKEY_CURRENT_USER\\Software\\Unity\\UnityEditor\\',
    'Editor Test Del Reg',
  );
  if (regdel) {
    console.log('delete the key successful');
  } else {
    console.log('Failed to delete the key');
  }
} else {
  console.log('Failed to create a key to delete it');
}

console.log('--------');
console.log('--done--');

// Ensure test exits, with either node or electron runtimes
if (Object.hasOwn(process.versions, 'electron')) {
  console.log('Electron runtime detected. Exiting.');
  process.exit(0);
}
